/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.commit;

import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.commit.CommitDiscussionParticipantDao;
import com.atlassian.stash.internal.commit.InternalCommitDiscussionParticipant;
import com.atlassian.stash.internal.participant.AbstractHibernateParticipantDao;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import java.util.Collections;
import javax.annotation.Nonnull;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="commitDiscussionParticipantDao")
public class HibernateCommitDiscussionParticipantDao
extends AbstractHibernateParticipantDao<InternalCommitDiscussionParticipant>
implements CommitDiscussionParticipantDao {
    @Autowired
    public HibernateCommitDiscussionParticipantDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Nonnull
    public Page<InternalCommitDiscussionParticipant> findByDiscussion(long discussionId, @Nonnull PageRequest pageRequest) {
        Criteria criteria = this.session().createCriteria(InternalCommitDiscussionParticipant.class).add((Criterion)Restrictions.eq((String)"discussion.id", (Object)discussionId));
        return HibernateUtils.initializePage(this.pageCriteria(this.applyImplicitOrder(criteria), pageRequest));
    }

    public InternalCommitDiscussionParticipant findByDiscussionAndUser(long discussionId, int userId) {
        Criteria criteria = this.session().createCriteria(InternalCommitDiscussionParticipant.class).add((Criterion)Restrictions.eq((String)"discussion.id", (Object)discussionId)).add((Criterion)Restrictions.eq((String)"user.id", (Object)userId));
        return (InternalCommitDiscussionParticipant)HibernateUtils.initialize((Object)((InternalCommitDiscussionParticipant)criteria.uniqueResult()));
    }

    @Override
    @Nonnull
    public InternalCommitDiscussionParticipant update(@Nonnull InternalCommitDiscussionParticipant participant) {
        throw new UnsupportedOperationException("CommitDiscussionParticipants are immutable and cannot be updated.");
    }

    @Override
    protected Iterable<Order> getImplicitOrder() {
        return Collections.singleton(Order.asc((String)"id"));
    }
}

