/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.backup.liquibase.xml;

import com.atlassian.stash.internal.backup.liquibase.xml.DelegatingXmlStreamWriter;
import com.google.common.base.Preconditions;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang.StringUtils;

public class PrettyXmlWriter
extends DelegatingXmlStreamWriter<XMLStreamWriter> {
    private static final int INDENT_SIZE = 4;
    private int indentLevel;
    private boolean previousElementClosed = true;

    public PrettyXmlWriter(XMLStreamWriter delegate) {
        super(delegate);
    }

    public void setIndentLevel(int level) {
        Preconditions.checkArgument((level > -1 ? 1 : 0) != 0);
        this.indentLevel = level;
    }

    public int getIndentLevel() {
        return this.indentLevel;
    }

    @Override
    public void writeStartElement(String s) throws XMLStreamException {
        this.writeIndentationShim();
        super.writeStartElement(s);
        ++this.indentLevel;
        this.previousElementClosed = false;
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.indentLevel = Math.max(0, this.indentLevel - 1);
        if (this.previousElementClosed) {
            this.writeIndentationShim();
        }
        super.writeEndElement();
        this.previousElementClosed = true;
    }

    @Override
    public void writeEmptyElement(String s) throws XMLStreamException {
        this.writeIndentationShim();
        super.writeEmptyElement(s);
        this.previousElementClosed = true;
    }

    private void writeIndentationShim() throws XMLStreamException {
        this.writeCharacters(StringUtils.rightPad((String)"\n", (int)(4 * this.indentLevel + 1)));
    }
}

