/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.backup.liquibase;

import com.atlassian.stash.internal.backup.liquibase.LiquibaseDataAccessException;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseSession;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseUnsupportedDatabaseException;
import com.google.common.base.Function;
import java.sql.Connection;
import java.sql.SQLException;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.core.UnsupportedDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.database.structure.Column;
import liquibase.database.structure.Table;
import liquibase.database.typeconversion.TypeConverter;
import liquibase.database.typeconversion.TypeConverterFactory;
import liquibase.exception.DatabaseException;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.DatabaseSnapshotGeneratorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.CleanupFailureDataAccessException;
import org.springframework.jdbc.CannotGetJdbcConnectionException;

public class DefaultLiquibaseSession
implements LiquibaseSession {
    private static final Logger log = LoggerFactory.getLogger(DefaultLiquibaseSession.class);
    public static final Function<Table, String> TO_LOWERCASE_TABLE_NAME = new Function<Table, String>(){

        public String apply(Table table) {
            return table.getName().toLowerCase();
        }
    };
    public static final Function<Column, String> TO_LOWERCASE_COLUMN_NAME = new Function<Column, String>(){

        public String apply(Column column) {
            return column.getName().toLowerCase();
        }
    };
    private final Database database;
    private DatabaseSnapshot snapshot;
    private long changeCount;
    private TypeConverter cachedTypeConverter;

    private static Database findDatabase(DataSource dataSource) {
        Database database = DefaultLiquibaseSession.findDatabaseForConnection(DefaultLiquibaseSession.getConnection(dataSource));
        if (database instanceof UnsupportedDatabase) {
            throw new LiquibaseUnsupportedDatabaseException(database.getDatabaseProductName());
        }
        return database;
    }

    private static Database findDatabaseForConnection(Connection connection) {
        try {
            return DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(connection));
        }
        catch (DatabaseException e) {
            throw new LiquibaseDataAccessException("Failed to find a database implementation", (Throwable)e);
        }
    }

    private static Connection getConnection(DataSource dataSource) {
        try {
            Connection connection = dataSource.getConnection();
            if (connection == null) {
                throw new IllegalStateException("Data source produced null connection");
            }
            return connection;
        }
        catch (SQLException e) {
            throw new CannotGetJdbcConnectionException("JDBC connection could not be obtained for use by Liquibase DAO", e);
        }
    }

    public DefaultLiquibaseSession(DataSource dataSource) {
        this.database = DefaultLiquibaseSession.findDatabase(dataSource);
    }

    public DefaultLiquibaseSession(Connection connection) {
        this.database = DefaultLiquibaseSession.findDatabaseForConnection(connection);
    }

    @Override
    public Database getDatabase() {
        return this.database;
    }

    @Override
    public DatabaseSnapshot getSnapshot() {
        if (this.snapshot == null) {
            log.info("Examining structure of source database");
            DatabaseSnapshotGeneratorFactory snapShotFactory = DatabaseSnapshotGeneratorFactory.getInstance();
            try {
                this.snapshot = snapShotFactory.createSnapshot(this.database, null, null);
            }
            catch (DatabaseException e) {
                throw new LiquibaseDataAccessException("Failed to obtain snapshot", this.database, (Throwable)e);
            }
        }
        return this.snapshot;
    }

    @Override
    public void incrementChangeCount() {
        ++this.changeCount;
    }

    @Override
    public long getChangeCount() {
        return this.changeCount;
    }

    @Override
    @Nonnull
    public TypeConverter getTypeConverter() {
        if (this.cachedTypeConverter == null) {
            this.cachedTypeConverter = TypeConverterFactory.getInstance().findTypeConverter(this.getDatabase());
        }
        return this.cachedTypeConverter;
    }

    @Override
    public void resetChangeCount() {
        this.changeCount = 0L;
    }

    @Override
    public void close() {
        log.debug("Closing Liquibase");
        try {
            this.getDatabase().close();
            log.debug("Liquibase closed");
        }
        catch (DatabaseException e) {
            throw new CleanupFailureDataAccessException("Failed to close database", (Throwable)e);
        }
    }
}

