/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.backup.liquibase;

import com.atlassian.fugue.Effect;
import com.atlassian.fugue.Option;
import com.atlassian.stash.internal.backup.liquibase.DefaultLiquibaseSession;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseChangeExecutionException;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseDao;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseDataAccessException;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseSessionThreadLocal;
import com.atlassian.stash.internal.liquibase.LiquibaseUtils;
import com.atlassian.stash.util.CancelState;
import com.atlassian.stash.util.Chainable;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import liquibase.change.Change;
import liquibase.change.ColumnConfig;
import liquibase.change.core.DeleteDataChange;
import liquibase.change.core.InsertDataChange;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.database.structure.Column;
import liquibase.database.structure.Table;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.LockException;
import liquibase.lockservice.LockService;
import liquibase.sql.visitor.SqlVisitor;
import liquibase.util.JdbcUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.dao.CannotAcquireLockException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.stereotype.Component;

@Component(value="liquibaseDao")
public class DefaultLiquibaseDao
implements ApplicationContextAware,
LiquibaseDao {
    public static final DatabaseChangeLog EMPTY_CHANGE_LOG = new DatabaseChangeLog();
    public static final List<SqlVisitor> NO_VISITORS = ImmutableList.of();
    private static final Logger log = LoggerFactory.getLogger(DefaultLiquibaseDao.class);
    private static final Predicate<String> IS_HIBERNATE_TEMPORARY_TABLE = new Predicate<String>(){

        public boolean apply(String tableName) {
            return tableName.startsWith("ht_") || tableName.length() == 29 && tableName.startsWith("t_");
        }
    };
    private static final Effect<LockService> RELEASE_LOCK = new Effect<LockService>(){

        public void apply(LockService lockService) {
            try {
                lockService.releaseLock();
            }
            catch (LockException e) {
                log.error("Failed to release Liquibase lock", (Throwable)e);
            }
        }
    };
    private final LiquibaseSessionThreadLocal databaseSession;
    private final long commitBlockSize;
    private Option<LockService> lockService = Option.none();
    private ApplicationContext applicationContext;

    @Autowired
    public DefaultLiquibaseDao(@Qualifier(value="backupDataSourceSupplier") Supplier<DataSource> dataSourceSupplier, @Value(value="${liquibase.commit.block.size}") long commitBlockSize) {
        this.commitBlockSize = commitBlockSize;
        this.databaseSession = new LiquibaseSessionThreadLocal(dataSourceSupplier);
    }

    public void beginChangeSet() {
        if (this.databaseSession.getDatabase().supportsDDLInTransaction()) {
            try {
                this.databaseSession.getDatabase().setAutoCommit(false);
            }
            catch (DatabaseException e) {
                throw new LiquibaseDataAccessException("Failed to set auto-commit off", this.databaseSession.getDatabase(), (Throwable)e);
            }
        }
    }

    public void close() {
        this.unlock();
        this.databaseSession.close();
        this.databaseSession.remove();
    }

    public long countRows(@Nonnull String tableName) {
        long l;
        Preconditions.checkNotNull((Object)tableName, (Object)"tableName");
        String escapedTableName = this.databaseSession.getDatabase().escapeTableName(this.databaseSession.getSnapshot().getSchema(), tableName);
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            Connection connection = LiquibaseUtils.getConnection(this.databaseSession.getDatabase());
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT count(1) FROM " + escapedTableName);
            resultSet.next();
            l = resultSet.getLong(1);
        }
        catch (SQLException e) {
            try {
                throw new DataRetrievalFailureException("Could not count rows for " + tableName, (Throwable)e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(resultSet);
                JdbcUtils.closeStatement(statement);
                throw throwable;
            }
        }
        JdbcUtils.closeResultSet((ResultSet)resultSet);
        JdbcUtils.closeStatement((Statement)statement);
        return l;
    }

    public void createSchema(DataSource dataSource) throws LiquibaseException {
        this.applicationContext.getBean("liquibasePrototype", new Object[]{dataSource});
    }

    public void deleteAllRows(@Nonnull String tableName) {
        DeleteDataChange change = new DeleteDataChange();
        change.setTableName(tableName);
        this.applyChange((Change)change);
        this.commit();
    }

    public void endChangeSet() {
        this.commit();
    }

    public Set<Class<?>> findCustomChanges() {
        return LiquibaseUtils.findCustomChanges();
    }

    public long forEachRow(@Nonnull String tableName, String orderingColumn, @Nonnull CancelState cancelState, @Nonnull Effect<Map<String, Object>> effect) {
        long l;
        Preconditions.checkNotNull((Object)tableName, (Object)"tableName");
        Preconditions.checkArgument((orderingColumn == null || StringUtils.isNotBlank((String)orderingColumn) ? 1 : 0) != 0, (Object)"blank ordering column");
        Preconditions.checkNotNull(effect, (Object)"effect");
        Table table = this.databaseSession.getSnapshot().getTable(tableName);
        String escapedTableName = this.databaseSession.getDatabase().escapeTableName(this.databaseSession.getSnapshot().getSchema(), tableName);
        long numberOfRows = 0L;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            Connection connection = LiquibaseUtils.getConnection(this.databaseSession.getDatabase());
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT * FROM " + escapedTableName + this.orderByClause(table, orderingColumn));
            while (resultSet.next() && !cancelState.isCanceled()) {
                this.forCurrentRow(table, resultSet, effect);
                ++numberOfRows;
            }
            l = numberOfRows;
        }
        catch (SQLException e) {
            try {
                throw new DataRetrievalFailureException("Could not fetch rows from " + tableName, (Throwable)e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(resultSet);
                JdbcUtils.closeStatement(statement);
                throw throwable;
            }
        }
        JdbcUtils.closeResultSet((ResultSet)resultSet);
        JdbcUtils.closeStatement((Statement)statement);
        return l;
    }

    @Nonnull
    public Iterable<String> getColumnNames(@Nonnull String tableName) {
        return Chainable.chain((Iterable)this.findTable(tableName).getColumns()).transform(DefaultLiquibaseSession.TO_LOWERCASE_COLUMN_NAME).toSet();
    }

    @Nonnull
    public String getDatabaseType() {
        return this.databaseSession.getDatabase().getTypeName();
    }

    @Nonnull
    public Iterable<String> getTableNames() {
        return Chainable.chain((Iterable)this.databaseSession.getSnapshot().getTables()).transform(DefaultLiquibaseSession.TO_LOWERCASE_TABLE_NAME).filter(Predicates.not(IS_HIBERNATE_TEMPORARY_TABLE)).toList();
    }

    public void insert(@Nonnull InsertDataChange change) {
        List columns = change.getColumns();
        Database database = this.databaseSession.getDatabase();
        StringBuilder builder = new StringBuilder("insert into ").append(database.escapeTableName(change.getSchemaName(), change.getTableName())).append(" (");
        StringBuilder questions = new StringBuilder();
        for (ColumnConfig column : columns) {
            if (questions.length() > 0) {
                builder.append(", ");
                questions.append(", ");
            }
            builder.append(database.escapeColumnName(change.getSchemaName(), change.getTableName(), column.getName()));
            questions.append("?");
        }
        builder.append(") values (").append((CharSequence)questions).append(")");
        Connection connection = LiquibaseUtils.getConnection(database);
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(builder.toString());
            for (int i = 0; i < columns.size(); ++i) {
                ColumnConfig column = (ColumnConfig)columns.get(i);
                Object value = column.getValueObject();
                statement.setObject(i + 1, value);
            }
            statement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new LiquibaseChangeExecutionException((Change)change, (Throwable)e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(statement);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement((Statement)statement);
        this.commitIfBlockFilled();
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withLock(Effect<LiquibaseDao> effect) {
        this.lock();
        try {
            effect.apply((Object)this);
        }
        finally {
            this.unlock();
        }
    }

    @VisibleForTesting
    void applyChange(Change change) {
        try {
            change.init();
            this.databaseSession.getDatabase().executeStatements(change, EMPTY_CHANGE_LOG, NO_VISITORS);
            log.debug(change.getConfirmationMessage());
            this.databaseSession.incrementChangeCount();
        }
        catch (LiquibaseException e) {
            throw new LiquibaseChangeExecutionException(change, (Throwable)e);
        }
    }

    @VisibleForTesting
    void commit() {
        try {
            this.databaseSession.getDatabase().commit();
            this.databaseSession.resetChangeCount();
        }
        catch (DatabaseException e) {
            throw new LiquibaseDataAccessException("Failed to commit changes to database", this.databaseSession.getDatabase(), (Throwable)e);
        }
    }

    @VisibleForTesting
    LockService getLockService(Database database) {
        return LockService.getInstance((Database)database);
    }

    @VisibleForTesting
    void rollback() {
        try {
            this.databaseSession.getDatabase().rollback();
            this.databaseSession.resetChangeCount();
        }
        catch (DatabaseException e) {
            throw new LiquibaseDataAccessException("Failed to rollback changes to database", this.databaseSession.getDatabase(), (Throwable)e);
        }
    }

    @VisibleForTesting
    Object transformValue(Database database, Object value, int dataType, int columnSize) {
        if (database instanceof OracleDatabase && dataType == 3 && columnSize == 1 && (BigDecimal.ZERO.equals(value) || BigDecimal.ONE.equals(value))) {
            value = BigDecimal.ONE.equals(value);
        }
        return value;
    }

    private static Predicate<Table> byTableName(final String tableName) {
        return new Predicate<Table>(){

            public boolean apply(Table table) {
                return table.getName().equalsIgnoreCase(tableName);
            }
        };
    }

    private void commitIfBlockFilled() {
        if (this.commitBlockSize > 0L && this.databaseSession.getChangeCount() >= this.commitBlockSize) {
            this.commit();
        }
    }

    private Table findTable(String tableName) {
        try {
            return (Table)Iterables.find((Iterable)this.databaseSession.getSnapshot().getTables(), DefaultLiquibaseDao.byTableName(tableName));
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException(String.format("No table '%s' in database snapshot", tableName));
        }
    }

    private void forCurrentRow(Table table, ResultSet resultSet, Effect<Map<String, Object>> effect) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        int columnCount = metaData.getColumnCount();
        HashMap columnValues = Maps.newHashMapWithExpectedSize((int)columnCount);
        for (int i = 1; i <= columnCount; ++i) {
            String columnName = this.getColumnName(metaData, i);
            columnValues.put(columnName, this.getValue(resultSet, i, table.getDatabase(), table.getColumn(columnName)));
        }
        effect.apply((Object)columnValues);
    }

    private String getColumnName(ResultSetMetaData metaData, int columnIndex) throws SQLException {
        return metaData.getColumnName(columnIndex).toLowerCase();
    }

    private Object getValue(ResultSet resultSet, int index, Database database, Column column) throws SQLException {
        return this.transformValue(database, JdbcUtils.getResultSetValue((ResultSet)resultSet, (int)index), column.getDataType(), column.getColumnSize());
    }

    private void lock() {
        log.debug("Locking Liquibase");
        LockService service = this.getLockService(this.databaseSession.getDatabase());
        try {
            service.waitForLock();
            this.lockService = Option.some((Object)service);
            log.debug("Liquibase locked");
        }
        catch (LockException e) {
            throw new CannotAcquireLockException("Could not lock Liquibase change log", (Throwable)e);
        }
    }

    private String orderByClause(Table table, String column) {
        return column == null ? "" : String.format(" ORDER BY %s ASC", this.databaseSession.getDatabase().escapeColumnName(table.getSchema(), table.getName(), table.getColumn(column).getName()));
    }

    private void unlock() {
        log.debug("Unlocking Liquibase");
        this.lockService.foreach(RELEASE_LOCK);
        this.lockService = Option.none();
        log.debug("Liquibase unlocked");
    }
}

