/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.backup.liquibase;

import com.atlassian.stash.internal.backup.liquibase.ColumnSerialisationType;
import com.atlassian.stash.internal.backup.liquibase.xml.XmlEncoder;
import liquibase.change.ColumnConfig;

final class ColumnParsingContext {
    private final StringBuilder buffer;
    private final String columnName;
    private final ColumnSerialisationType columnSerialisationType;

    ColumnParsingContext(String columnName, ColumnSerialisationType columnSerialisationType) {
        this.columnName = columnName;
        this.columnSerialisationType = columnSerialisationType;
        this.buffer = new StringBuilder();
    }

    void append(char[] ch, int start, int len) {
        this.buffer.append(ch, start, len);
    }

    ColumnConfig asColumnConfig(XmlEncoder xmlEncoder) {
        ColumnConfig column = new ColumnConfig();
        column.setName(this.columnName);
        String decoded = xmlEncoder.decode(this.buffer.toString());
        switch (this.columnSerialisationType) {
            case BOOLEAN: {
                column.setValueBoolean(Boolean.valueOf(Boolean.parseBoolean(decoded)));
                break;
            }
            case NUMERIC: {
                column.setValueNumeric(decoded);
                break;
            }
            case DATE: {
                column.setValueDate(decoded);
                break;
            }
            default: {
                column.setValue(decoded);
            }
        }
        return column;
    }
}

