/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.backup.liquibase;

import com.atlassian.fugue.Effect;
import com.atlassian.fugue.Option;
import com.atlassian.stash.internal.backup.liquibase.ColumnParsingContext;
import com.atlassian.stash.internal.backup.liquibase.ColumnSerialisationType;
import com.atlassian.stash.internal.backup.liquibase.processors.ChangeSetProcessor;
import com.atlassian.stash.internal.backup.liquibase.xml.XmlEncoder;
import com.atlassian.stash.util.CancelState;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import liquibase.change.core.DeleteDataChange;
import liquibase.change.core.InsertDataChange;
import liquibase.changelog.ChangeSet;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ChangeSetReader
extends DefaultHandler {
    private final CancelState cancelState;
    private final ChangeSetProcessor processor;
    private final XmlEncoder xmlEncoder;
    private ChangeSet changeSet;
    private DeleteDataChange deleteDataChange;
    private InsertDataChange insertDataChange;
    private Option<ColumnParsingContext> columnContextOption = Option.none();

    public ChangeSetReader(@Nonnull CancelState cancelState, @Nonnull ChangeSetProcessor processor, @Nonnull XmlEncoder xmlEncoder) {
        this.cancelState = (CancelState)Preconditions.checkNotNull((Object)cancelState, (Object)"cancelState");
        this.processor = (ChangeSetProcessor)Preconditions.checkNotNull((Object)processor, (Object)"processor");
        this.xmlEncoder = (XmlEncoder)Preconditions.checkNotNull((Object)xmlEncoder, (Object)"xmlEncoder");
    }

    @Override
    public void characters(final char[] ch, final int start, final int length) throws SAXException {
        if (!this.cancelState.isCanceled()) {
            this.columnContextOption.foreach((Effect)new Effect<ColumnParsingContext>(){

                public void apply(ColumnParsingContext context) {
                    context.append(ch, start, length);
                }
            });
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.cancelState.isCanceled()) {
            return;
        }
        if (this.changeSet != null && "changeSet".equals(qName)) {
            this.processor.onChangesetComplete(this.changeSet);
            this.changeSet = null;
        } else if (this.columnContextOption.isDefined() && "column".equals(qName)) {
            this.insertDataChange.addColumn(((ColumnParsingContext)this.columnContextOption.get()).asColumnConfig(this.xmlEncoder));
            this.columnContextOption = Option.none();
        } else if (this.insertDataChange != null && "insert".equals(qName)) {
            if (this.insertDataChange.getColumns().size() > 0) {
                this.processor.onChangesetContent(this.insertDataChange);
                this.insertDataChange = null;
            }
        } else if (this.deleteDataChange != null && "delete".equals(qName)) {
            this.processor.onChangesetContent(this.deleteDataChange);
            this.deleteDataChange = null;
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.cancelState.isCanceled()) {
            return;
        }
        if (this.changeSet == null && "changeSet".equals(qName)) {
            this.changeSet = this.newChangeSet(attributes);
            this.processor.onChangesetBegin(this.changeSet);
        } else if (this.changeSet != null && this.insertDataChange == null && "insert".equals(qName)) {
            this.insertDataChange = new InsertDataChange();
            this.insertDataChange.setTableName(attributes.getValue("tableName"));
        } else if (this.changeSet != null && this.deleteDataChange == null && "delete".equals(qName)) {
            this.deleteDataChange = new DeleteDataChange();
            this.deleteDataChange.setTableName(attributes.getValue("tableName"));
        } else if (this.insertDataChange != null && "column".equals(qName)) {
            String columnName = attributes.getValue("name");
            ColumnSerialisationType columnSerialisationType = (ColumnSerialisationType)((Object)ColumnSerialisationType.fromString(attributes.getValue("colType")).get());
            this.columnContextOption = Option.some((Object)new ColumnParsingContext(columnName, columnSerialisationType));
        }
    }

    private ChangeSet newChangeSet(Attributes attributes) {
        boolean alwaysRun = false;
        boolean runOnChange = false;
        boolean runInTxn = false;
        String filePath = "restore";
        String id = attributes.getValue("id");
        String author = attributes.getValue("author");
        String contextString = attributes.getValue("context");
        String dbms = attributes.getValue("dbms");
        return new ChangeSet(id, author, alwaysRun, runOnChange, filePath, contextString, dbms, runInTxn);
    }
}

