/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.hibernate.HibernatePageUtils;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.user.InternalRepositoryAccess;
import com.atlassian.stash.internal.user.RepositoryAccessDao;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collections;
import javax.annotation.Nonnull;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="repositoryAccessDao")
public class HibernateRepositoryAccessDao
extends AbstractHibernateDao<InternalRepositoryAccess.PK, InternalRepositoryAccess>
implements RepositoryAccessDao {
    @Autowired
    public HibernateRepositoryAccessDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public int deleteAllAccessesForRepository(int repositoryId) {
        return this.session().createQuery("delete from InternalRepositoryAccess where repository.id = :repositoryId").setInteger("repositoryId", repositoryId).executeUpdate();
    }

    public int deleteAllAccessesForUser(int userId) {
        return this.session().createQuery("delete from InternalRepositoryAccess where user.id = :userId").setInteger("userId", userId).executeUpdate();
    }

    public Page<InternalRepository> findRecentRepositories(int userId, @Nonnull PageRequest pageRequest, @Nonnull Predicate<? super InternalRepository> predicate) {
        Criteria criteria = this.createCriteria(userId).setProjection((Projection)Projections.property((String)"repository"));
        return HibernateUtils.initializePage(HibernatePageUtils.pageCriteria(criteria, pageRequest, predicate));
    }

    public void trimRecentRepositories(int userId, int pageLimit, @Nonnull Predicate<InternalRepositoryAccess> predicate) {
        Page<InternalRepositoryAccess> repoAccesses = this.pageCriteria(this.createCriteria(userId), HibernatePageUtils.newRequest((int)0, (int)pageLimit), predicate);
        if (!repoAccesses.getIsLastPage() && repoAccesses.getSize() > 0) {
            long lastAccessed = ((InternalRepositoryAccess)Iterables.getLast((Iterable)repoAccesses.getValues())).getLastAccessed().getTime();
            this.session().createQuery("delete InternalRepositoryAccess where user.id = :userId and lastAccessed < :minLastAccessed").setInteger("userId", userId).setLong("minLastAccessed", lastAccessed).executeUpdate();
        }
    }

    @Override
    protected Iterable<Order> getImplicitOrder() {
        return Collections.singleton(Order.desc((String)"lastAccessed"));
    }

    private Criteria createCriteria(int userId) {
        Criteria criteria = this.session().createCriteria(InternalRepositoryAccess.class).add((Criterion)Restrictions.eq((String)"user.id", (Object)userId));
        return this.applyImplicitOrder(criteria);
    }
}

