/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.RepositoryActivityDao;
import com.atlassian.stash.internal.repository.RepositoryDao;
import com.atlassian.stash.internal.repository.RepositoryOrder;
import com.atlassian.stash.internal.repository.RepositoryScopedIdGenerator;
import com.atlassian.stash.internal.repository.RepositorySearchCriteria;
import com.atlassian.stash.project.ProjectType;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="repositoryDao")
public class HibernateRepositoryDao
extends AbstractHibernateDao<Integer, InternalRepository>
implements RepositoryDao {
    private final RepositoryActivityDao activityDao;
    private final RepositoryScopedIdGenerator idGenerator;

    @Autowired
    public HibernateRepositoryDao(SessionFactory sessionFactory, RepositoryActivityDao activityDao, RepositoryScopedIdGenerator idGenerator) {
        super(sessionFactory);
        this.activityDao = activityDao;
        this.idGenerator = idGenerator;
    }

    public long countAll() {
        return HibernateUtils.count((Criteria)this.session().createCriteria(InternalRepository.class));
    }

    public long countByHierarchy(String hierarchyId) {
        return HibernateUtils.count((Criteria)this.session().createCriteria(InternalRepository.class).add((Criterion)Restrictions.eq((String)"hierarchyId", (Object)hierarchyId)));
    }

    public long countByProject(int projectId) {
        return HibernateUtils.count((Criteria)this.session().createCriteria(InternalRepository.class).add((Criterion)Restrictions.eq((String)"project.id", (Object)projectId)));
    }

    public long countPublicByProject(int projectId) {
        return HibernateUtils.count((Criteria)this.session().createCriteria(InternalRepository.class).add((Criterion)Restrictions.eq((String)"project.id", (Object)projectId)).add((Criterion)Restrictions.eq((String)"publiclyAccessible", (Object)true)).setCacheable(true).setCacheRegion("query.publicRepositoryCountByProject"));
    }

    @Override
    public InternalRepository create(InternalRepository entity) {
        InternalRepository created = super.create(entity);
        this.session().flush();
        this.idGenerator.prepare(created.getId().intValue());
        return created;
    }

    @Override
    public void delete(InternalRepository entity) {
        this.cleanup(entity.getId());
        super.delete(entity);
    }

    @Override
    public void deleteById(Integer id) {
        this.cleanup(id);
        super.deleteById(id);
    }

    @Override
    @Nonnull
    public Page<InternalRepository> findAll(PageRequest pageRequest) {
        return HibernateUtils.initializePage(super.findAll(pageRequest));
    }

    @Override
    @Nonnull
    public Page<InternalRepository> findAll(PageRequest pageRequest, Predicate<? super InternalRepository> predicate) {
        return HibernateUtils.initializePage(super.findAll(pageRequest, predicate));
    }

    @Nonnull
    public Page<InternalRepository> findByHierarchy(@Nonnull InternalRepository repository, @Nonnull PageRequest pageRequest, @Nonnull Predicate<? super InternalRepository> predicate) {
        String hql = "from InternalRepository where id != :repositoryId and hierarchyId = :hierarchyId order by project.key, name";
        Query query = this.session().createQuery(hql).setInteger("repositoryId", repository.getId().intValue()).setString("hierarchyId", repository.getHierarchyId()).setCacheable(true).setCacheRegion("query.repositoriesByHierarchy");
        return HibernateUtils.initializePage(this.pageQuery(query, pageRequest, predicate));
    }

    @Nonnull
    public Page<InternalRepository> findByOrigin(@Nonnull InternalRepository origin, @Nonnull PageRequest pageRequest, @Nonnull Predicate<? super InternalRepository> predicate) {
        Criteria criteria = this.session().createCriteria(InternalRepository.class).add((Criterion)Restrictions.eq((String)"origin", (Object)origin));
        this.applyImplicitOrder(criteria);
        return HibernateUtils.initializePage(this.pageCriteria(criteria, pageRequest, predicate));
    }

    public InternalRepository findByOriginInProject(@Nonnull InternalRepository origin, int projectId) {
        return (InternalRepository)HibernateUtils.initialize((Object)((InternalRepository)this.session().createCriteria(InternalRepository.class).add((Criterion)Restrictions.eq((String)"origin", (Object)origin)).add((Criterion)Restrictions.eq((String)"project.id", (Object)projectId)).add((Criterion)Restrictions.eq((String)"slug", (Object)origin.getSlug())).uniqueResult()));
    }

    @Nonnull
    public Page<InternalRepository> findByOwner(int ownerId, @Nonnull PageRequest pageRequest, @Nonnull Predicate<? super InternalRepository> predicate) {
        String hql = "select r from InternalRepository r, InternalPersonalProject p where r.project = p and p.owner.id = :ownerId order by upper(r.name)";
        Query query = this.session().createQuery(hql).setInteger("ownerId", ownerId);
        return HibernateUtils.initializePage(this.pageQuery(query, pageRequest, predicate));
    }

    @Nonnull
    public Page<InternalRepository> findByProjectKey(@Nonnull String projectKey, @Nonnull PageRequest pageRequest, @Nonnull Predicate<? super InternalRepository> predicate) {
        String hql = "from InternalRepository where upper(project.key) = upper(:projectKey) order by upper(name)";
        Query query = this.session().createQuery(hql).setParameter("projectKey", (Object)projectKey);
        return HibernateUtils.initializePage(this.pageQuery(query, pageRequest, predicate));
    }

    @Override
    public InternalRepository getById(Integer id) {
        return (InternalRepository)HibernateUtils.initialize(super.getById(id));
    }

    @Override
    @Nonnull
    public List<InternalRepository> getByIds(@Nonnull Collection<Integer> ids) {
        return HibernateUtils.initializeList(super.getByIds(ids));
    }

    public InternalRepository getBySlug(@Nonnull String projectKey, @Nonnull String slug) {
        String hql = "from InternalRepository where upper(project.key) = upper(:projectKey) and slug = :slug";
        return (InternalRepository)HibernateUtils.initialize((Object)((InternalRepository)this.session().createQuery(hql).setString("slug", slug.toLowerCase(Locale.US)).setString("projectKey", projectKey).setCacheable(true).setCacheRegion("query.repositoryBySlug").uniqueResult()));
    }

    @Nonnull
    public List<Integer> getForkIds(@Nonnull InternalRepository repository) {
        return this.session().createCriteria(InternalRepository.class).add((Criterion)Restrictions.eq((String)"origin", (Object)repository)).setProjection((Projection)Projections.id()).list();
    }

    @Nonnull
    public Page<InternalRepository> search(@Nonnull RepositorySearchCriteria searchCriteria, @Nonnull PageRequest pageRequest, @Nonnull Predicate<? super InternalRepository> predicate) {
        Criteria criteria = this.createCriteria();
        if (this.requiresProjectJoin(searchCriteria)) {
            criteria.createAlias("project", "p");
        }
        this.maybeRestrictRepositoryName(searchCriteria, criteria);
        this.maybeRestrictProjectName(searchCriteria, criteria);
        this.maybeRestrictVisibility(searchCriteria, criteria);
        this.addOrder(searchCriteria, criteria);
        return HibernateUtils.initializePage(this.pageCriteria(criteria, pageRequest, predicate));
    }

    @Override
    public InternalRepository update(InternalRepository entity) {
        return (InternalRepository)HibernateUtils.initialize((Object)super.update(entity));
    }

    public int updateOrigin(@Nonnull InternalRepository oldOrigin, InternalRepository newOrigin) {
        Query query = newOrigin == null ? this.session().createQuery("update InternalRepository set origin = null where origin = :oldOrigin") : this.session().createQuery("update InternalRepository set origin = :newOrigin where origin = :oldOrigin").setParameter("newOrigin", (Object)newOrigin);
        return query.setParameter("oldOrigin", (Object)oldOrigin).executeUpdate();
    }

    @Override
    protected Iterable<Order> getImplicitOrder() {
        return RepositoryOrder.DEFAULT.getOrder();
    }

    private void addOrder(RepositorySearchCriteria searchCriteria, Criteria criteria) {
        searchCriteria.getOrder().apply(criteria);
    }

    private void cleanup(int repositoryId) {
        Session session = this.session();
        session.createQuery("delete from InternalWatcher where watchable.id in (select id from InternalCommitDiscussion where repository.id = :repoId) and watchable.class = :typeId").setInteger("repoId", repositoryId).setInteger("typeId", 2).executeUpdate();
        List commentIds = session.createQuery("select distinct comment.id from InternalCommitDiscussionCommentActivity where repository.id = :repoId order by comment.id desc").setInteger("repoId", repositoryId).list();
        this.activityDao.deleteByRepository(repositoryId);
        this.deleteComments(commentIds);
        session.flush();
    }

    private void deleteComments(List<Long> commentIds) {
        if (commentIds.isEmpty()) {
            return;
        }
        for (List ids : Lists.partition(commentIds, (int)100)) {
            this.session().createQuery("delete from InternalComment where id in (:commentIds)").setParameterList("commentIds", (Collection)ids).executeUpdate();
        }
    }

    private void maybeRestrictProjectName(RepositorySearchCriteria searchCriteria, Criteria criteria) {
        if (searchCriteria.hasProjectName()) {
            criteria.add(Restrictions.ilike((String)"p.name", (String)searchCriteria.getProjectName(), (MatchMode)MatchMode.START));
            criteria.add((Criterion)Restrictions.eq((String)"p.type", (Object)ProjectType.NORMAL));
        }
    }

    private void maybeRestrictRepositoryName(RepositorySearchCriteria searchCriteria, Criteria criteria) {
        if (searchCriteria.hasName()) {
            criteria.add(Restrictions.ilike((String)"name", (String)searchCriteria.getName(), (MatchMode)MatchMode.START));
        }
    }

    private void maybeRestrictVisibility(RepositorySearchCriteria searchCriteria, Criteria criteria) {
        if (searchCriteria.hasVisibility()) {
            switch (searchCriteria.getVisibility()) {
                case PUBLIC: {
                    criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"publiclyAccessible", (Object)true), (Criterion)Restrictions.eq((String)"p.publiclyAccessible", (Object)true)));
                    break;
                }
                case PRIVATE: {
                    criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.ne((String)"publiclyAccessible", (Object)true), (Criterion)Restrictions.ne((String)"p.publiclyAccessible", (Object)true)));
                }
            }
        }
    }

    private boolean requiresProjectJoin(RepositorySearchCriteria searchCriteria) {
        return searchCriteria.getOrder() == RepositoryOrder.PROJECT_NAME || searchCriteria.hasVisibility() || searchCriteria.hasProjectName();
    }
}

