/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.liquibase;

import com.atlassian.stash.internal.liquibase.AbstractCustomChange;
import com.atlassian.stash.internal.liquibase.LiquibaseUtils;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import liquibase.change.custom.CustomTaskChange;
import liquibase.change.custom.CustomTaskRollback;
import liquibase.database.Database;
import liquibase.exception.CustomChangeException;
import liquibase.exception.RollbackImpossibleException;
import liquibase.exception.UnsupportedChangeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;

public class FillInRootCommentsChange
extends AbstractCustomChange
implements CustomTaskChange,
CustomTaskRollback {
    public static final int MAX_REPLY_NESTING = 50;
    private static final Logger log = LoggerFactory.getLogger(FillInRootCommentsChange.class);

    public void execute(Database database) throws CustomChangeException {
        int level;
        Map<Long, Long> rootRepliesAndTheirRoots = this.getRootRepliesAndTheirRoots(database);
        log.debug("Setting roots on {} top-level replies", (Object)rootRepliesAndTheirRoots.size());
        this.setRoots(database, rootRepliesAndTheirRoots);
        Map<Long, Long> unrootedReplies = this.getUnrootedReplies(database);
        for (level = 0; level < 50 && !unrootedReplies.isEmpty(); ++level) {
            log.debug("Setting roots on {} replies at level {}", (Object)unrootedReplies.size(), (Object)(level + 1));
            this.setRoots(database, unrootedReplies);
            unrootedReplies = this.getUnrootedReplies(database);
        }
        if (!unrootedReplies.isEmpty()) {
            throw new CustomChangeException(String.format("Failed to set comment roots - too much comment nesting detected. Gave up at level %d", level + 1));
        }
    }

    public String getConfirmationMessage() {
        return "Comment roots successfully set for all replies";
    }

    public void rollback(Database database) throws CustomChangeException, UnsupportedChangeException, RollbackImpossibleException {
        try {
            JdbcTemplate template = LiquibaseUtils.getJdbcTemplate(database);
            template.update("UPDATE sta_comment SET root_id = NULL");
        }
        catch (DataAccessException e) {
            log.error("Failed to rollback rooting of replies", (Throwable)e);
            throw new CustomChangeException("Failed to rollback data in sta_comment", (Throwable)e);
        }
    }

    private Map<Long, Long> getRootRepliesAndTheirRoots(Database database) throws CustomChangeException {
        try {
            final HashMap result = Maps.newHashMap();
            JdbcTemplate template = LiquibaseUtils.getJdbcTemplate(database);
            template.query("select c1.id as reply_id, c2.id as root_id from sta_comment c1 inner join sta_comment c2 on c1.parent_id = c2.id where c2.parent_id is NULL", new RowCallbackHandler(){

                public void processRow(ResultSet rs) throws SQLException {
                    long replyId = rs.getLong("reply_id");
                    long rootId = rs.getLong("root_id");
                    result.put(replyId, rootId);
                }
            });
            return result;
        }
        catch (DataAccessException e) {
            log.error("Failed to query root replies", (Throwable)e);
            throw new CustomChangeException("Failed to select data from sta_comment", (Throwable)e);
        }
    }

    private Map<Long, Long> getUnrootedReplies(Database database) throws CustomChangeException {
        try {
            final HashMap result = Maps.newHashMap();
            JdbcTemplate template = LiquibaseUtils.getJdbcTemplate(database);
            template.query("select c1.id as reply_id, c2.root_id as root_id from sta_comment c1 inner join sta_comment c2 on c1.parent_id = c2.id where c1.root_id is NULL and c2.root_id is not NULL", new RowCallbackHandler(){

                public void processRow(ResultSet rs) throws SQLException {
                    long replyId = rs.getLong("reply_id");
                    long rootId = rs.getLong("root_id");
                    result.put(replyId, rootId);
                }
            });
            return result;
        }
        catch (DataAccessException e) {
            log.error("Failed to query unrooted replies", (Throwable)e);
            throw new CustomChangeException("Failed to select data from sta_comment", (Throwable)e);
        }
    }

    private void setRoots(Database database, Map<Long, Long> repliesAndTheirRoots) throws CustomChangeException {
        if (!repliesAndTheirRoots.isEmpty()) {
            try {
                JdbcTemplate template = LiquibaseUtils.getJdbcTemplate(database);
                Iterable batches = Iterables.partition((Iterable)Collections2.transform(repliesAndTheirRoots.entrySet(), (Function)new Function<Map.Entry<Long, Long>, Object[]>(){

                    public Object[] apply(Map.Entry<Long, Long> entry) {
                        return new Object[]{entry.getValue(), entry.getKey()};
                    }
                }), (int)25);
                boolean debug = log.isDebugEnabled();
                int batchCount = 0;
                for (List batch : batches) {
                    if (debug) {
                        log.debug("Executing batch {} of setting roots for this level of reply", (Object)batchCount);
                    }
                    int[] results = template.batchUpdate("UPDATE sta_comment SET root_id = ? WHERE id = ?", batch, new int[]{-5, -5});
                    if (debug) {
                        log.debug("Results of executing batch {} of setting roots for this level of reply: {}", (Object)batchCount, (Object)Arrays.toString(results));
                    }
                    ++batchCount;
                }
            }
            catch (DataAccessException e) {
                log.error("Failed to set roots for replies", (Throwable)e);
                throw new CustomChangeException("Failed to update data in sta_comment", (Throwable)e);
            }
        }
    }
}

