/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.backup.liquibase.processors;

import com.atlassian.stash.internal.backup.liquibase.processors.ChangeSetProcessor;
import com.google.common.base.CharMatcher;
import liquibase.change.ColumnConfig;
import liquibase.change.core.DeleteDataChange;
import liquibase.change.core.InsertDataChange;
import liquibase.changelog.ChangeSet;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NullFilteringChangeSetProcessor
implements ChangeSetProcessor {
    private static final Logger log = LoggerFactory.getLogger(NullFilteringChangeSetProcessor.class);
    private static final CharMatcher NULL_CHAR_MATCHER = CharMatcher.is((char)'\u0000');

    @Override
    public void onChangesetBegin(ChangeSet changeSet) {
    }

    @Override
    public void onChangesetContent(InsertDataChange change) {
        for (ColumnConfig columnConfig : change.getColumns()) {
            String value = columnConfig.getValue();
            if (value == null || !NULL_CHAR_MATCHER.matchesAnyOf((CharSequence)value)) continue;
            columnConfig.setValue(NULL_CHAR_MATCHER.removeFrom((CharSequence)value));
            log.warn("Removed the null characters (U+0000) on the following row on the table '{}':\n - id: '{}'\n - column: '{}'\n - value: '{}'", new Object[]{change.getTableName(), this.findRowId(change), columnConfig.getName(), StringUtils.abbreviate((String)columnConfig.getValue(), (int)50)});
        }
    }

    @Override
    public void onChangesetContent(DeleteDataChange change) {
    }

    @Override
    public void onChangesetComplete(ChangeSet changeSet) {
    }

    private String findRowId(InsertDataChange change) {
        for (ColumnConfig column : change.getColumns()) {
            if (!column.getName().equalsIgnoreCase("id")) continue;
            if (column.getValueNumeric() != null) {
                return column.getValueNumeric().toString();
            }
            if (column.getValueObject() != null) {
                return column.getValueObject().toString();
            }
            if (column.getValue() == null) continue;
            return column.getValue();
        }
        return "?";
    }
}

