/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.activity;

import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.activity.ActivityLock;
import com.atlassian.stash.internal.activity.InternalActivity;
import com.atlassian.stash.util.concurrent.LockGuard;
import java.util.Arrays;
import java.util.Map;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Order;

public class AbstractHibernateActivityDao<A extends InternalActivity>
extends AbstractHibernateDao<Long, A> {
    protected final ActivityLock activityLock;

    public AbstractHibernateActivityDao(SessionFactory sessionFactory, ActivityLock activityLock) {
        super(sessionFactory);
        this.activityLock = activityLock;
    }

    @Override
    public A create(A entity) {
        try (LockGuard ignored = this.activityLock.forCreate();){
            InternalActivity internalActivity = (InternalActivity)super.create(entity);
            return (A)internalActivity;
        }
    }

    @Override
    public void delete(A entity) {
        try (LockGuard ignored = this.activityLock.forDelete();){
            super.delete(entity);
        }
    }

    @Override
    public void deleteById(Long id) {
        try (LockGuard ignored = this.activityLock.forDelete();){
            super.deleteById(id);
        }
    }

    @Override
    protected Iterable<Order> getImplicitOrder() {
        return Arrays.asList(Order.desc((String)"createdDate"), Order.desc((String)"id"));
    }

    @Override
    protected int maybeBulkDelete(String hql, Map<String, Object> parameters) {
        try (LockGuard ignored = this.activityLock.forDelete();){
            int n = super.maybeBulkDelete(hql, parameters);
            return n;
        }
    }
}

