/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.security.random.SecureTokenGenerator;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.setting.InternalSharedLob;
import com.atlassian.stash.internal.user.InternalNormalUser;
import com.atlassian.stash.internal.user.InternalServiceUser;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.internal.user.InternalStashUserVisitor;
import com.atlassian.stash.internal.user.InternalUserSettings;
import com.atlassian.stash.internal.user.StashUserDao;
import com.atlassian.stash.user.UserType;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageUtils;
import com.atlassian.stash.util.UserUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Order;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="stashUserDao")
public class HibernateStashUserDao
extends AbstractHibernateDao<Integer, InternalStashUser>
implements StashUserDao {
    private static final Logger log = LoggerFactory.getLogger(HibernateStashUserDao.class);
    @VisibleForTesting
    static final String USER_SETTINGS = String.format("{\"%s\":%b}", "SHOW_GETTING_STARTED_PAGE", true);
    private static final String FIELD_USERNAME = "username";
    private static final String FIELD_DISPLAY_NAME = "displayName";
    private static final String FIELD_SLUG = "slug";
    private static final String FIELD_DELETED_DATE = "deletedDate";
    private static final int MAX_USERNAME_LENGTH = 255;
    private static final Function<String, String> FORMAT_USERNAME = new Function<String, String>(){

        public String apply(String username) {
            return IdentifierUtils.toLowerCase((String)username);
        }
    };
    private static final Function<? super Principal, String> TO_FORMATTED_USERNAME = Functions.compose(FORMAT_USERNAME, (Function)UserUtils.TO_USERNAME);
    private final SecureTokenGenerator tokenGenerator;

    @Autowired
    public HibernateStashUserDao(SessionFactory sessionFactory, SecureTokenGenerator tokenGenerator) {
        super(sessionFactory);
        this.tokenGenerator = tokenGenerator;
    }

    @Nonnull
    public InternalNormalUser archive(@Nonnull InternalNormalUser user) {
        String archivedSlug;
        Preconditions.checkArgument((!((InternalNormalUser)Preconditions.checkNotNull((Object)user, (Object)"user")).isCrowdBacked() ? 1 : 0) != 0, (Object)"Only deleted users can be archived");
        int counter = 0;
        String suffix = "_ar";
        String archivedName = this.safeAppendSuffix(user.getName(), 255, suffix);
        while (this.findByName(archivedName) != null && ++counter < 100) {
            suffix = "_ar" + counter;
            archivedName = this.safeAppendSuffix(user.getName(), 255, suffix);
        }
        if (counter == 100) {
            archivedName = this.tokenGenerator.generateToken();
            while (this.findByName(archivedName) != null) {
                archivedName = this.tokenGenerator.generateToken();
            }
            archivedSlug = this.generateUniqueSlugForUser(archivedName, user);
        } else {
            archivedSlug = this.generateUniqueSlugForUser(this.safeAppendSuffix(user.getName(), 126, suffix), user);
        }
        log.info("Archiving user {} with slug {} to {}/{}", new Object[]{user.getName(), user.getSlug(), archivedName, archivedSlug});
        return this.update(user.copy().name(archivedName).slug(archivedSlug).build());
    }

    @Override
    @Nonnull
    public InternalNormalUser create(@Nonnull InternalNormalUser user) {
        String slug = this.generateUniqueSlug(user.getName());
        return (InternalNormalUser)((InternalStashUser)super.create(user.copy().slug(slug).build())).accept((InternalStashUserVisitor)InternalNormalUser.TO_NORMAL_USER);
    }

    @Override
    @Nonnull
    public InternalServiceUser create(@Nonnull InternalServiceUser user) {
        return (InternalServiceUser)((InternalStashUser)super.create(user)).accept((InternalStashUserVisitor)InternalServiceUser.TO_SERVICE_USER);
    }

    @Override
    public InternalStashUser create(@Nonnull InternalStashUser user) {
        Preconditions.checkNotNull((Object)user, (Object)"user");
        return (InternalStashUser)user.accept((InternalStashUserVisitor)new InternalStashUserVisitor<InternalStashUser>(){

            public InternalStashUser visit(@Nonnull InternalNormalUser user) {
                return HibernateStashUserDao.this.create(user);
            }

            public InternalStashUser visit(@Nonnull InternalServiceUser user) {
                return HibernateStashUserDao.this.create(user);
            }
        });
    }

    @Override
    @Nonnull
    public Page<InternalStashUser> findAll(@Nonnull PageRequest pageRequest) {
        return this.findAll(UserType.NORMAL, pageRequest);
    }

    @Nonnull
    public Page<InternalStashUser> findAll(@Nonnull UserType userType, @Nonnull PageRequest pageRequest) {
        Criteria criteria = this.session().createCriteria(this.userClassForType(userType)).addOrder(this.orderFor(userType));
        return this.pageCriteria(criteria, pageRequest);
    }

    @Override
    @Nonnull
    public Page<InternalStashUser> findAll(@Nonnull PageRequest pageRequest, @Nonnull Predicate<? super InternalStashUser> predicate) {
        return this.findAll(UserType.NORMAL, pageRequest, predicate);
    }

    @Nonnull
    public Page<InternalStashUser> findAll(@Nonnull UserType userType, @Nonnull PageRequest pageRequest, @Nonnull Predicate<? super InternalStashUser> predicate) {
        Criteria criteria = this.session().createCriteria(this.userClassForType(userType)).addOrder(this.orderFor(userType));
        return this.pageCriteria(criteria, pageRequest, predicate);
    }

    public InternalNormalUser findByName(@Nonnull String username) {
        return (InternalNormalUser)this.session().createQuery("from InternalNormalUser where username = :username").setParameter(FIELD_USERNAME, FORMAT_USERNAME.apply((Object)username)).uniqueResult();
    }

    public InternalNormalUser findBySlug(@Nonnull String slug) {
        return (InternalNormalUser)this.session().createQuery("from InternalNormalUser where slug = :slug").setParameter(FIELD_SLUG, (Object)slug).uniqueResult();
    }

    @Nonnull
    public Set<InternalNormalUser> findByNames(@Nonnull Set<String> usernames) {
        if (usernames.isEmpty()) {
            return Collections.emptySet();
        }
        Query query = this.session().createQuery("from InternalNormalUser where username in (:usernames) order by username").setParameterList("usernames", Collections2.transform(usernames, FORMAT_USERNAME));
        return ImmutableSet.copyOf((Collection)query.list());
    }

    @Nonnull
    public Page<InternalServiceUser> findServiceUsersByName(@Nullable String displayName, @Nonnull PageRequest pageRequest) {
        Query query;
        if (StringUtils.isBlank((String)displayName)) {
            query = this.session().createQuery("from InternalServiceUser order by displayName");
        } else {
            query = this.session().createQuery("from InternalServiceUser where lower(displayName) like :displayName order by displayName");
            query.setParameter(FIELD_DISPLAY_NAME, (Object)("%" + IdentifierUtils.toLowerCase((String)displayName) + "%"));
        }
        return PageUtils.asPageOf(InternalServiceUser.class, this.pageQuery(query, pageRequest));
    }

    @Nonnull
    public Page<InternalNormalUser> findByDeletedDateEarlierThan(@Nonnull Date date, @Nonnull PageRequest pageRequest) {
        Query query = this.session().createQuery("from InternalNormalUser where deletedDate is not null and deletedDate < :deletedDate order by username").setParameter(FIELD_DELETED_DATE, (Object)date);
        return PageUtils.asPageOf(InternalNormalUser.class, this.pageQuery(query, pageRequest));
    }

    public InternalNormalUser loadUser(@Nonnull User user) {
        Object[] result = (Object[])this.session().createQuery("select id, slug, locale from InternalNormalUser where username = :username").setParameter(FIELD_USERNAME, FORMAT_USERNAME.apply((Object)user.getName())).uniqueResult();
        if (result == null) {
            return null;
        }
        int id = ((Number)result[0]).intValue();
        String slug = (String)result[1];
        Locale locale = (Locale)result[2];
        return ((InternalNormalUser.Builder)new InternalNormalUser.Builder().crowdUser(user).id(Integer.valueOf(id))).locale(locale).name(user.getName()).slug(slug).build();
    }

    @Nonnull
    public Set<InternalNormalUser> loadUsers(@Nonnull Iterable<User> users) {
        ImmutableMap usersByName = Maps.uniqueIndex(users, TO_FORMATTED_USERNAME);
        if (usersByName.isEmpty()) {
            return Collections.emptySet();
        }
        List results = this.session().createQuery("select username, id, slug, locale from InternalNormalUser where username in :usernames").setParameterList("usernames", usersByName.keySet()).list();
        HashSet<InternalNormalUser> stashUsers = new HashSet<InternalNormalUser>(usersByName.size(), 1.0f);
        for (Object result : results) {
            Object[] columns = (Object[])result;
            stashUsers.add(((InternalNormalUser.Builder)new InternalNormalUser.Builder().crowdUser((User)usersByName.get(columns[0])).id(Integer.valueOf(((Number)columns[1]).intValue()))).slug((String)columns[2]).name((String)columns[0]).locale((Locale)columns[3]).build());
        }
        return stashUsers;
    }

    public InternalNormalUser rename(@Nonnull String oldUsername, @Nonnull String newUsername) {
        InternalNormalUser user = this.findByName(oldUsername);
        if (user == null) {
            return null;
        }
        InternalNormalUser updated = this.update(user.copy().name(newUsername).slug(this.generateUniqueSlugForUser(newUsername, user)).build());
        return updated;
    }

    @Nonnull
    public InternalNormalUser createFor(@Nonnull User crowdUser) {
        InternalNormalUser user = this.findByName(crowdUser.getName());
        if (user == null) {
            user = this.create(new InternalNormalUser.Builder().name(crowdUser.getName()).build());
            InternalSharedLob settingsLob = new InternalSharedLob.Builder().data(USER_SETTINGS).build();
            this.session().saveOrUpdate((Object)new InternalUserSettings.Builder().user((InternalStashUser)user).settings(settingsLob).build());
        } else if (user.getDeletedDate() != null) {
            this.update(user.copy().deletedDate(null).build());
        }
        return user;
    }

    @Override
    protected Iterable<Order> getImplicitOrder() {
        return Collections.singleton(Order.asc((String)FIELD_USERNAME));
    }

    private String generateUniqueSlug(String username) {
        return this.generateUniqueSlugForUser(username, null);
    }

    private String generateUniqueSlugForUser(String username, InternalNormalUser user) {
        String initialSlug;
        String slug = initialSlug = InternalNormalUser.slugify((String)username);
        boolean slugFound = false;
        for (int tries = 0; tries <= 10; ++tries) {
            if (this.isSlugFree(slug, user)) {
                log.debug("{}: Using slug \"{}\"", (Object)username, (Object)slug);
                slugFound = true;
                break;
            }
            log.debug("{}: Collision detected for slug \"{}\"", (Object)username, (Object)slug);
            slug = initialSlug + tries;
        }
        if (!slugFound) {
            slug = InternalNormalUser.generateSlug((SecureTokenGenerator)this.tokenGenerator);
            log.debug("{}: Using random token \"{}\" as slug", (Object)username, (Object)slug);
        }
        return slug;
    }

    private boolean isSlugFree(String slug, InternalNormalUser user) {
        InternalNormalUser slugUser = this.findBySlug(slug);
        return slugUser == null || user != null && slugUser.getId().equals(user.getId());
    }

    private String safeAppendSuffix(String username, int maxResultLength, String suffix) {
        return username.substring(0, Math.min(maxResultLength - suffix.length(), username.length())) + suffix;
    }

    private Class<? extends InternalStashUser> userClassForType(UserType userType) {
        return userType == UserType.NORMAL ? InternalNormalUser.class : InternalServiceUser.class;
    }

    private Order orderFor(UserType userType) {
        if (userType == UserType.NORMAL) {
            return this.getImplicitOrder().iterator().next();
        }
        return Order.asc((String)FIELD_DISPLAY_NAME);
    }
}

