/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.hibernate.HibernatePageUtils;
import com.atlassian.stash.internal.user.EffectivePermissionDao;
import com.atlassian.stash.internal.user.GroupPermissionCriteria;
import com.atlassian.stash.internal.user.InternalGlobalPermission;
import com.atlassian.stash.internal.user.InternalGrantedPermission;
import com.atlassian.stash.internal.user.InternalNormalUser;
import com.atlassian.stash.internal.user.PermissionCriteria;
import com.atlassian.stash.internal.user.UserPermissionCriteria;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.Subqueries;
import org.hibernate.sql.JoinType;
import org.springframework.beans.factory.annotation.Autowired;

@org.springframework.stereotype.Repository(value="effectivePermissionDao")
public class HibernateEffectivePermissionDao
extends AbstractHibernateDao<Long, InternalGrantedPermission>
implements EffectivePermissionDao {
    @Autowired
    public HibernateEffectivePermissionDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Nonnull
    public Page<InternalGrantedPermission> findByGroup(@Nonnull String group, @Nonnull PageRequest pageRequest) {
        Query query = this.session().createQuery("select p from InternalGrantedPermission p, InternalPermissionType t where p.permission = t.id and p.user is null and p.group = :groupName order by id asc").setString("groupName", group);
        return HibernatePageUtils.pageQuery(query, pageRequest);
    }

    @Nonnull
    public Page<InternalGrantedPermission> findByUserId(@Nonnull Integer userId, @Nonnull PageRequest pageRequest) {
        Query query = this.session().createQuery("select p from InternalGrantedPermission p, InternalPermissionType t where p.permission = t.id and p.user = :userId and p.group is null order by id asc").setInteger("userId", userId.intValue());
        return HibernatePageUtils.pageQuery(query, pageRequest);
    }

    @Nonnull
    public Page<String> findGroups(@Nonnull Permission permission, @Nonnull PageRequest pageRequest) {
        Criteria criteria = DetachedCriteria.forClass(InternalGlobalPermission.class).add(Restrictions.in((String)"permission", (Collection)permission.getInheritingPermissions())).add(Restrictions.isNull((String)"user")).add(Restrictions.isNotNull((String)"group")).addOrder(Order.asc((String)"group")).setProjection(Projections.distinct((Projection)Projections.property((String)"group"))).getExecutableCriteria(this.session()).setCacheable(true).setCacheRegion("query.permissions");
        return HibernatePageUtils.pageCriteria(criteria, pageRequest);
    }

    @Nonnull
    public Page<StashUser> findUsers(@Nonnull Permission permission, @Nonnull PageRequest pageRequest, @Nonnull Predicate<? super StashUser> predicate) {
        DetachedCriteria permissionCriteria = DetachedCriteria.forClass(InternalGlobalPermission.class).add(Restrictions.in((String)"permission", (Collection)permission.getInheritingPermissions())).add(Restrictions.isNotNull((String)"user")).add(Restrictions.isNull((String)"group")).setProjection(Projections.distinct((Projection)Projections.property((String)"user.id")));
        Criteria userCriteria = this.session().createCriteria(InternalNormalUser.class).add(Subqueries.propertyIn((String)"id", (DetachedCriteria)permissionCriteria)).addOrder(Order.asc((String)"username"));
        return HibernatePageUtils.pageCriteria(userCriteria, pageRequest, predicate);
    }

    public boolean isGrantedToGroup(@Nonnull GroupPermissionCriteria criteria) {
        Permission permission = criteria.getPermission();
        Set groups = criteria.getGroups();
        DetachedCriteria permissionCriteria = DetachedCriteria.forClass(InternalGrantedPermission.class).add(Restrictions.in((String)"permission", (Collection)permission.getInheritingPermissions())).add(Restrictions.isNull((String)"user")).add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"group"), (Criterion)Restrictions.in((String)"group", (Collection)Collections2.transform((Collection)groups, (Function)IdentifierUtils.TO_LOWER_CASE)))).setProjection((Projection)Projections.count((String)"id"));
        this.includeResourceIds((PermissionCriteria)criteria, permissionCriteria);
        return (Long)permissionCriteria.getExecutableCriteria(this.session()).setCacheable(true).setCacheRegion("query.permissions").uniqueResult() > 0L;
    }

    public boolean isGrantedToUser(@Nonnull UserPermissionCriteria criteria) {
        Permission permission = criteria.getPermission();
        Integer userId = criteria.getUserId();
        DetachedCriteria permissionCriteria = DetachedCriteria.forClass(InternalGrantedPermission.class).add(Restrictions.in((String)"permission", (Collection)permission.getInheritingPermissions())).add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"user"), (Criterion)Restrictions.eq((String)"user.id", (Object)userId))).add(Restrictions.isNull((String)"group"));
        this.includeResourceIds((PermissionCriteria)criteria, permissionCriteria);
        return (Long)permissionCriteria.getExecutableCriteria(this.session()).setProjection((Projection)Projections.count((String)"id")).uniqueResult() > 0L;
    }

    @Override
    protected Iterable<Order> getImplicitOrder() {
        return Collections.singleton(Order.asc((String)"id"));
    }

    private void includeResourceIds(PermissionCriteria criteria, DetachedCriteria permissionCriteria) {
        Permission permission = criteria.getPermission();
        Integer projectId = criteria.getProjectId();
        Integer repositoryId = criteria.getRepositoryId();
        if (permission.isGlobal()) {
            permissionCriteria.add(Restrictions.isNull((String)"project")).add(Restrictions.isNull((String)"repository"));
        } else if (permission.isResource(Project.class) && !Permission.PROJECT_VIEW.equals((Object)permission)) {
            permissionCriteria.add(Restrictions.isNull((String)"repository"));
            if (projectId != null) {
                permissionCriteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"project"), (Criterion)Restrictions.eq((String)"project.id", (Object)projectId)));
            }
        } else if (permission.isResource(Repository.class) || Permission.PROJECT_VIEW.equals((Object)permission)) {
            if (projectId != null || repositoryId != null) {
                Disjunction disjunction = Restrictions.disjunction();
                disjunction.add((Criterion)Restrictions.and((Criterion)Restrictions.isNull((String)"project"), (Criterion)Restrictions.isNull((String)"repository")));
                if (projectId != null) {
                    disjunction.add((Criterion)Restrictions.eq((String)"project.id", (Object)projectId));
                }
                if (repositoryId != null) {
                    disjunction.add((Criterion)Restrictions.eq((String)"repository.id", (Object)repositoryId));
                } else if (Permission.PROJECT_VIEW.equals((Object)permission)) {
                    permissionCriteria.createAlias("repository", "joinRepository", JoinType.LEFT_OUTER_JOIN);
                    disjunction.add((Criterion)Restrictions.eq((String)"joinRepository.project.id", (Object)projectId));
                }
                permissionCriteria.add((Criterion)disjunction);
            }
        } else {
            throw new IllegalArgumentException("Unsupported permission: " + permission);
        }
    }
}

