/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment.drift;

import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.comment.drift.CommentDriftRequestDao;
import com.atlassian.stash.internal.pull.comment.drift.InternalDriftRequest;
import com.atlassian.stash.util.Chainable;
import com.google.common.base.Function;
import com.google.common.base.Predicates;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="driftRequestDao")
public class HibernateCommentDriftRequestDao
implements CommentDriftRequestDao {
    private static final Function<InternalDriftRequest, Long> TO_ID = new Function<InternalDriftRequest, Long>(){

        public Long apply(InternalDriftRequest internalDriftRequest) {
            return internalDriftRequest.getId();
        }
    };
    private final SessionFactory sessionFactory;

    @Autowired
    public HibernateCommentDriftRequestDao(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Nonnull
    public InternalDriftRequest create(@Nonnull InternalDriftRequest request) {
        this.session().save((Object)request);
        return request;
    }

    public void deleteAll(@Nonnull List<InternalDriftRequest> requests) {
        List requestIds = Chainable.chain(requests).transform(TO_ID).filter(Predicates.notNull()).toList();
        if (!requestIds.isEmpty()) {
            this.session().createQuery("delete from InternalDriftRequest where id in (:ids)").setParameterList("ids", (Collection)requestIds).executeUpdate();
        }
    }

    @Nonnull
    public List<InternalDriftRequest> findAll() {
        return HibernateUtils.initializeList((List)this.session().createQuery("from InternalDriftRequest order by id asc").list());
    }

    @Nonnull
    public List<InternalDriftRequest> findByGlobalId(long globalId) {
        return HibernateUtils.initializeList((List)this.session().createQuery("from InternalDriftRequest r where r.pullRequest.id = :globalId order by id asc").setLong("globalId", globalId).list());
    }

    @Nonnull
    public List<InternalPullRequest> findPendingPullRequests() {
        return HibernateUtils.initializeList((List)this.session().createQuery("select p from InternalPullRequest p where p.id in (select distinct r.pullRequest.id from InternalDriftRequest r)").list());
    }

    public InternalDriftRequest getById(@Nonnull Long id) {
        InternalDriftRequest request = (InternalDriftRequest)this.session().get(InternalDriftRequest.class, (Serializable)id);
        return (InternalDriftRequest)HibernateUtils.initialize((Object)request);
    }

    private Session session() {
        return this.sessionFactory.getCurrentSession();
    }
}

