/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.pull.InternalRescopeRequest;
import com.atlassian.stash.internal.pull.RescopeRequestDao;
import com.atlassian.stash.util.Chainable;
import com.google.common.base.Predicates;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Order;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="rescopeRequestDao")
public class HibernateRescopeRequestDao
extends AbstractHibernateDao<Long, InternalRescopeRequest>
implements RescopeRequestDao {
    @Autowired
    public HibernateRescopeRequestDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public void deleteAll(@Nonnull List<InternalRescopeRequest> requests) {
        List requestIds = Chainable.chain(requests).transform(InternalRescopeRequest.TO_ID).filter(Predicates.notNull()).toList();
        if (!requestIds.isEmpty()) {
            this.session().createQuery("delete from InternalRescopeRequest where id in (:ids)").setParameterList("ids", (Collection)requestIds).executeUpdate();
        }
    }

    @Nonnull
    public List<InternalRescopeRequest> findAll() {
        return HibernateUtils.initializeList((List)this.session().createQuery("from InternalRescopeRequest order by id asc").list());
    }

    @Override
    public InternalRescopeRequest getById(@Nonnull Long id) {
        return (InternalRescopeRequest)HibernateUtils.initialize(super.getById(id));
    }

    @Override
    @Nonnull
    public List<InternalRescopeRequest> getByIds(@Nonnull Collection<Long> ids) {
        return HibernateUtils.initializeList(super.getByIds(ids));
    }

    @Override
    protected Iterable<Order> getImplicitOrder() {
        return Collections.singleton(Order.asc((String)"id"));
    }
}

