/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.liquibase;

import com.atlassian.security.random.DefaultSecureTokenGenerator;
import com.atlassian.security.random.SecureTokenGenerator;
import com.atlassian.stash.internal.liquibase.AbstractCustomChange;
import com.atlassian.stash.internal.liquibase.LiquibaseUtils;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import liquibase.change.custom.CustomTaskChange;
import liquibase.change.custom.CustomTaskRollback;
import liquibase.database.Database;
import liquibase.exception.CustomChangeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;

public class SetHierarchyIdsChange
extends AbstractCustomChange
implements CustomTaskChange,
CustomTaskRollback {
    private final SecureTokenGenerator tokenGenerator = DefaultSecureTokenGenerator.getInstance();
    private static final Logger log = LoggerFactory.getLogger(SetHierarchyIdsChange.class);
    private int hierarchies;
    private int repositories;

    public void execute(Database database) throws CustomChangeException {
        JdbcTemplate template = LiquibaseUtils.getJdbcTemplate(database);
        final HashMap idToParentMap = Maps.newHashMap();
        template.query("select id, origin_id from repository order by id", new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                int id = resultSet.getInt(1);
                int parent = resultSet.getInt(2);
                idToParentMap.put(id, resultSet.wasNull() ? null : Integer.valueOf(parent));
            }
        });
        if (idToParentMap.isEmpty()) {
            log.info("No repositories exist; no hierarchy IDs need to be set");
            return;
        }
        this.repositories = idToParentMap.size();
        log.debug("Loaded {} repositories to set hierarchy IDs", (Object)this.repositories);
        final HashMap idToHierarchyMap = new HashMap(this.repositories);
        for (Map.Entry entry : idToParentMap.entrySet()) {
            String hierarchyId;
            Integer parent = (Integer)entry.getValue();
            if (parent == null) {
                hierarchyId = this.tokenGenerator.generateToken();
                if (hierarchyId.length() > 20) {
                    hierarchyId = hierarchyId.substring(0, 20);
                }
                ++this.hierarchies;
            } else {
                hierarchyId = (String)idToHierarchyMap.get(parent);
            }
            idToHierarchyMap.put(entry.getKey(), hierarchyId);
        }
        log.debug("Applying hierarchy IDs to {} repositories", (Object)this.repositories);
        Iterable partitions = Iterables.partition(idToParentMap.keySet(), (int)25);
        for (final List partition : partitions) {
            template.batchUpdate("update repository set hierarchy_id = ? where id = ?", new BatchPreparedStatementSetter(){

                public int getBatchSize() {
                    return partition.size();
                }

                public void setValues(PreparedStatement preparedStatement, int i) throws SQLException {
                    Integer id = (Integer)partition.get(i);
                    String hierarchyId = (String)idToHierarchyMap.get(id);
                    preparedStatement.setString(1, hierarchyId);
                    preparedStatement.setInt(2, id);
                }
            });
        }
        log.debug(this.getConfirmationMessage());
    }

    public String getConfirmationMessage() {
        return "Assigned " + this.hierarchies + " hierarchies across " + this.repositories + " repositories";
    }

    public void rollback(Database database) throws CustomChangeException {
        JdbcTemplate template = LiquibaseUtils.getJdbcTemplate(database);
        try {
            template.update("update repository set hierarchy_id = null");
        }
        catch (DataAccessException e) {
            throw new CustomChangeException("Hierarchy IDs could not be rolled back", (Throwable)e);
        }
    }
}

