/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.liquibase;

import com.atlassian.stash.internal.backup.DatabaseTable;
import com.atlassian.stash.internal.liquibase.AbstractCustomChange;
import liquibase.change.custom.CustomSqlChange;
import liquibase.change.custom.CustomSqlRollback;
import liquibase.database.Database;
import liquibase.exception.CustomChangeException;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.DeleteStatement;
import liquibase.statement.core.RawSqlStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateRepositoryHooksChange
extends AbstractCustomChange
implements CustomSqlChange,
CustomSqlRollback {
    public static final String CONFIGURED_HOOK_STATUS = "sta_configured_hook_status";
    public static final String REPO_HOOK = DatabaseTable.STA_REPO_HOOK.getTableName();
    public static final String REPO_SETTINGS = "sta_repo_settings";
    private static final Logger log = LoggerFactory.getLogger(PopulateRepositoryHooksChange.class);

    public SqlStatement[] generateRollbackStatements(Database database) {
        return new SqlStatement[]{new DeleteStatement(null, REPO_HOOK)};
    }

    public SqlStatement[] generateStatements(Database database) throws CustomChangeException {
        String hookKeyColumn = database.escapeDatabaseObject("hookkey");
        String idColumn = database.escapeDatabaseObject("id");
        String repoIdColumn = database.escapeDatabaseObject("repo_id");
        StringBuilder builder = new StringBuilder(384).append("INSERT INTO ").append(database.escapeTableName(null, REPO_HOOK)).append(" (").append(database.escapeColumnName(null, REPO_HOOK, "id")).append(", ").append(database.escapeColumnName(null, REPO_HOOK, "repository_id")).append(", ").append(database.escapeColumnName(null, REPO_HOOK, "hook_key")).append(", ").append(database.escapeColumnName(null, REPO_HOOK, "is_enabled")).append(", ").append(database.escapeColumnName(null, REPO_HOOK, "lob_id")).append(") (SELECT ").append("cs.").append(idColumn).append(", cs.").append(repoIdColumn).append(", cs.").append(hookKeyColumn).append(", cs.").append(database.escapeDatabaseObject("enabled")).append(", rs.").append(idColumn).append(" FROM ").append(database.escapeTableName(null, CONFIGURED_HOOK_STATUS)).append(" cs LEFT OUTER JOIN ").append(database.escapeTableName(null, REPO_SETTINGS)).append(" rs ON cs.").append(repoIdColumn).append(" = rs.").append(repoIdColumn).append(" AND cs.").append(hookKeyColumn).append(" = rs.").append(database.escapeDatabaseObject("setting_key")).append(")");
        log.debug("Generated SQL: {}", (Object)builder);
        return new SqlStatement[]{new RawSqlStatement(builder.toString())};
    }

    public String getConfirmationMessage() {
        return "Populated " + REPO_HOOK + " from " + CONFIGURED_HOOK_STATUS + " and " + REPO_SETTINGS;
    }
}

