/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.liquibase;

import com.atlassian.stash.internal.liquibase.AbstractCustomChange;
import com.atlassian.stash.internal.liquibase.LiquibaseUtils;
import com.google.common.collect.Maps;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import liquibase.change.custom.CustomTaskChange;
import liquibase.change.custom.CustomTaskRollback;
import liquibase.database.Database;
import liquibase.exception.CustomChangeException;
import liquibase.exception.RollbackImpossibleException;
import liquibase.exception.UnsupportedChangeException;
import org.apache.commons.codec.binary.Base64;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ParameterizedPreparedStatementSetter;
import org.springframework.jdbc.core.RowCallbackHandler;

public class BlobBase64EncodeChange
extends AbstractCustomChange
implements CustomTaskChange,
CustomTaskRollback {
    private String tableName;
    private String primaryKey;
    private String fromColumnName;
    private String toColumnName;
    private int charLimit = -1;

    public void execute(Database database) throws CustomChangeException {
        Map<Integer, String> data = this.selectData(database);
        this.updateTable(database, data);
    }

    private Map<Integer, String> selectData(Database database) throws CustomChangeException {
        JdbcTemplate template = LiquibaseUtils.getJdbcTemplate(database);
        final HashMap data = Maps.newHashMap();
        String sql = String.format("SELECT %s, %s FROM %s", database.escapeColumnName(null, this.tableName, this.primaryKey), database.escapeColumnName(null, this.tableName, this.fromColumnName), database.escapeTableName(null, this.tableName));
        template.query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                String transformedValue;
                long blobLength;
                int key = rs.getInt(BlobBase64EncodeChange.this.primaryKey);
                Blob blob = rs.getBlob(BlobBase64EncodeChange.this.fromColumnName);
                byte[] value = blob.getBytes(1L, (int)(blobLength = blob.length()));
                String string = transformedValue = value != null ? new String(Base64.encodeBase64((byte[])value)) : null;
                if (BlobBase64EncodeChange.this.charLimit > 0 && transformedValue != null && transformedValue.length() > BlobBase64EncodeChange.this.charLimit) {
                    throw new DataRetrievalFailureException(String.format("Failed to transform unbound BLOB on column %s to base64 bound char limit of %d on %s in table %s, key: %d", BlobBase64EncodeChange.this.fromColumnName, BlobBase64EncodeChange.this.charLimit, BlobBase64EncodeChange.this.toColumnName, BlobBase64EncodeChange.this.tableName, key));
                }
                data.put(key, transformedValue);
            }
        });
        return data;
    }

    private void updateTable(Database database, Map<Integer, String> data) throws CustomChangeException {
        if (data.isEmpty()) {
            return;
        }
        JdbcTemplate template = LiquibaseUtils.getJdbcTemplate(database);
        String sql = String.format("UPDATE %s SET %s = ? WHERE %s = ?", database.escapeTableName(null, this.tableName), database.escapeColumnName(null, this.tableName, this.toColumnName), database.escapeColumnName(null, this.tableName, this.primaryKey));
        template.batchUpdate(sql, data.entrySet(), data.size(), (ParameterizedPreparedStatementSetter)new ParameterizedPreparedStatementSetter<Map.Entry<Integer, String>>(){

            public void setValues(PreparedStatement statement, Map.Entry<Integer, String> entry) throws SQLException {
                statement.setString(1, entry.getValue());
                statement.setInt(2, entry.getKey());
            }
        });
    }

    public void rollback(Database database) throws CustomChangeException, UnsupportedChangeException, RollbackImpossibleException {
        JdbcTemplate template = LiquibaseUtils.getJdbcTemplate(database);
        template.update(String.format("UPDATE %s SET %s = NULL", database.escapeTableName(null, this.tableName), database.escapeColumnName(null, this.tableName, this.toColumnName)));
    }

    public String getConfirmationMessage() {
        return String.format("Converted blob data in %1$s.%2$s to base64 data in %1$s.%3$s", this.tableName, this.fromColumnName, this.toColumnName);
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setFromColumnName(String fromColumnName) {
        this.fromColumnName = fromColumnName;
    }

    public void setToColumnName(String toColumnName) {
        this.toColumnName = toColumnName;
    }

    public void setCharLimit(Integer charLimit) {
        this.charLimit = charLimit;
    }
}

