/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hibernate;

import com.atlassian.stash.internal.hibernate.DataSourceConfiguration;
import com.atlassian.stash.util.Drainable;
import com.google.common.annotations.VisibleForTesting;
import com.jolbox.bonecp.BoneCPDataSource;
import java.io.Closeable;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedBoneCPDataSource
extends BoneCPDataSource
implements Closeable,
DataSource,
Drainable {
    private static final long DEFAULT_DRAIN_POLL_INTERVAL = TimeUnit.SECONDS.toMillis(2L);
    private static final Logger log = LoggerFactory.getLogger(ExtendedBoneCPDataSource.class);
    private long drainPollInterval;

    public ExtendedBoneCPDataSource(DataSourceConfiguration configuration) {
        this.setDriverClass(configuration.getDriverClassName());
        this.setDriverProperties(configuration.getProperties());
        this.setJdbcUrl(configuration.getUrl());
        this.setPassword(configuration.getPassword());
        this.setUsername(configuration.getUser());
        this.drainPollInterval = DEFAULT_DRAIN_POLL_INTERVAL;
    }

    public boolean drain(long timeout, @Nonnull TimeUnit unit) {
        long start = System.currentTimeMillis();
        long end = start + unit.toMillis(timeout);
        log.debug("Draining the connection pool");
        int leased = this.getTotalLeased();
        while (leased > 0) {
            long tilEnd = end - System.currentTimeMillis();
            if (tilEnd <= 0L) {
                log.debug("The connection pool did not drain in {} {}; {} connections are still leased", new Object[]{timeout, unit, leased});
                return false;
            }
            long interval = Math.min(this.drainPollInterval, tilEnd);
            log.debug("{} connections still leased; waiting {} milliseconds", (Object)leased, (Object)interval);
            try {
                Thread.sleep(interval);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
            leased = this.getTotalLeased();
        }
        log.debug("The connection pool has drained in {} milliseconds", (Object)(System.currentTimeMillis() - start));
        return true;
    }

    @Override
    public java.util.logging.Logger getParentLogger() {
        return java.util.logging.Logger.getLogger("global");
    }

    public void setConnectionTimeoutInSeconds(int connectionTimeout) {
        this.setConnectionTimeoutInMs(TimeUnit.SECONDS.toMillis(connectionTimeout));
    }

    @VisibleForTesting
    void setDrainPollInterval(long drainPollInterval) {
        this.drainPollInterval = drainPollInterval;
    }
}

