/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hibernate;

import com.jolbox.bonecp.ConnectionHandle;
import com.jolbox.bonecp.hooks.AbstractConnectionHook;
import java.sql.Connection;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanupConnectionHook
extends AbstractConnectionHook {
    private static final Logger log = LoggerFactory.getLogger(CleanupConnectionHook.class);

    public void onCheckIn(ConnectionHandle handle) {
        if (handle.isPossiblyBroken()) {
            return;
        }
        try {
            Connection connection = handle.getInternalConnection();
            if (!connection.isClosed() && !connection.getAutoCommit()) {
                log.debug("A connection was checked into the connection pool with auto-commit disabled. Re-enabling auto-commit before returning to the pool.");
                connection.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            log.warn("Could not check or set the auto-commit status for the connection being checked in.", (Throwable)e);
        }
    }
}

