/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.db;

import com.atlassian.stash.internal.db.Database;
import com.atlassian.stash.repository.Version;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import javax.annotation.Nonnull;

public class JdbcMetadataDatabase
implements Database {
    private final int majorVersion;
    private final int minorVersion;
    private final String name;
    private final Version version;

    public JdbcMetadataDatabase(@Nonnull String name, @Nonnull Version version, int majorVersion, int minorVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.version = (Version)Preconditions.checkNotNull((Object)version, (Object)"version");
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public int getPatchVersion() {
        return (Integer)Iterables.get((Iterable)this.version.getVersion(), (int)2, (Object)0);
    }

    @Nonnull
    public Version getVersion() {
        return this.version;
    }
}

