/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.db;

import com.atlassian.stash.internal.db.Database;
import com.atlassian.stash.internal.db.DatabaseAffixed;
import com.atlassian.stash.internal.db.DatabaseSupplier;
import com.atlassian.stash.internal.db.DatabaseSupportLevel;
import com.atlassian.stash.internal.db.DbType;
import com.atlassian.stash.internal.db.DelegatingDetailedDatabase;
import com.atlassian.stash.internal.db.DetailedDatabase;
import com.atlassian.stash.internal.db.JdbcMetadataDatabase;
import com.atlassian.stash.internal.db.UnsupportedDatabaseException;
import com.atlassian.stash.repository.Version;
import com.atlassian.util.concurrent.LazyReference;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.stereotype.Component;

@Component(value="databaseSupplier")
public class DefaultDatabaseSupplier
implements DatabaseAffixed,
DatabaseSupplier {
    public static final String NAME_HSQL = "HSQL";
    public static final String NAME_MYSQL = "MySQL";
    public static final String NAME_ORACLE = "Oracle";
    public static final String NAME_POSTGRESQL = "PostgreSQL";
    public static final String NAME_SQL_SERVER = "Microsoft SQL Server";
    private static final String HSQL_PRODUCT_NAME = "HSQL Database Engine";
    private static final Map<String, Function<Database, DetailedDatabase>> NAMES_TO_DETAILERS = ImmutableMap.builder().put((Object)"HSQL", (Object)new HsqlSupportLevel()).put((Object)"Microsoft SQL Server", (Object)new SqlServerSupportLevel()).put((Object)"MySQL", (Object)new MySqlSupportLevel()).put((Object)"Oracle", (Object)new OracleSupportLevel()).put((Object)"PostgreSQL", (Object)new PostgresSupportLevel()).build();
    private static final Pattern PATTERN_ORACLE_VERSION = Pattern.compile(".+\\s([\\d\\.]+)\\s.*", 32);
    private static final Logger log = LoggerFactory.getLogger(DefaultDatabaseSupplier.class);
    private final ResettableLazyReference<DetailedDatabase> databaseReference;
    private boolean ignoreUnsupported;

    @Autowired
    public DefaultDatabaseSupplier(final DataSource dataSource) {
        this.databaseReference = new ResettableLazyReference<DetailedDatabase>(){

            protected DetailedDatabase create() {
                return DefaultDatabaseSupplier.detailsFor(dataSource);
            }
        };
    }

    @Nonnull
    public DetailedDatabase get() {
        try {
            return (DetailedDatabase)this.databaseReference.get();
        }
        catch (LazyReference.InitializationException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ExecutionException) {
                cause = cause.getCause();
            }
            Throwables.propagateIfPossible((Throwable)cause);
            throw e;
        }
    }

    @Nonnull
    public DetailedDatabase getForConnection(@Nonnull Connection connection) {
        return DefaultDatabaseSupplier.detailsFor(DefaultDatabaseSupplier.databaseFor((Connection)Preconditions.checkNotNull((Object)connection, (Object)"connection")));
    }

    public void release() {
        this.databaseReference.reset();
    }

    @Value(value="${jdbc.ignoreunsupported}")
    public void setIgnoreUnsupported(boolean ignoreUnsupported) {
        this.ignoreUnsupported = ignoreUnsupported;
    }

    @PostConstruct
    public void validate() {
        if (this.ignoreUnsupported) {
            log.warn("Not checking database support level; the check has been disabled");
            return;
        }
        DetailedDatabase database = this.get();
        if (DatabaseSupportLevel.UNSUPPORTED == database.getSupportLevel()) {
            throw new UnsupportedDatabaseException("The configured database is unsupported", (Database)database);
        }
    }

    @Nonnull
    private static Database databaseFor(Connection connection) {
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            String productName = metaData.getDatabaseProductName();
            String productVersion = metaData.getDatabaseProductVersion();
            int majorVersion = metaData.getDatabaseMajorVersion();
            int minorVersion = metaData.getDatabaseMinorVersion();
            Version version = DefaultDatabaseSupplier.parseVersion(productName, productVersion, majorVersion, minorVersion);
            return new JdbcMetadataDatabase(HSQL_PRODUCT_NAME.equals(productName) ? NAME_HSQL : productName, version, majorVersion, minorVersion);
        }
        catch (SQLException e) {
            throw new DataRetrievalFailureException("Could not load database metadata", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private static Database databaseFor(DataSource dataSource) {
        Connection connection = null;
        try {
            connection = DataSourceUtils.getConnection((DataSource)dataSource);
            Database database = DefaultDatabaseSupplier.databaseFor(connection);
            return database;
        }
        finally {
            DataSourceUtils.releaseConnection((Connection)connection, (DataSource)dataSource);
        }
    }

    @Nonnull
    private static DetailedDatabase detailsFor(Database database) {
        Function<Database, DetailedDatabase> detailer = NAMES_TO_DETAILERS.get(database.getName());
        if (detailer == null) {
            log.error("{} is not a supported database", (Object)database.getName());
            return new DelegatingDetailedDatabase(database, DatabaseSupportLevel.UNSUPPORTED, null);
        }
        return (DetailedDatabase)detailer.apply((Object)database);
    }

    @Nonnull
    private static DetailedDatabase detailsFor(DataSource dataSource) {
        return DefaultDatabaseSupplier.detailsFor(DefaultDatabaseSupplier.databaseFor(dataSource));
    }

    private static Version parseVersion(String productName, String productVersion, int majorVersion, int minorVersion) {
        if (NAME_ORACLE.equals(productName)) {
            Matcher matcher = PATTERN_ORACLE_VERSION.matcher(productVersion);
            if (matcher.matches()) {
                return new Version(matcher.group(1));
            }
            log.warn("Could not parse Oracle version [{}]; using major and minor versions", (Object)productVersion);
            return new Version(new Integer[]{majorVersion, minorVersion});
        }
        return new Version(productVersion);
    }

    private static class SqlServerSupportLevel
    extends AbstractSupportLevel {
        private static final Set<Integer> SUPPORTED_VERSIONS = ImmutableSet.of((Object)9, (Object)10, (Object)11, (Object)12);

        public SqlServerSupportLevel() {
            super(DbType.MSSQL);
        }

        @Override
        @Nonnull
        public DatabaseSupportLevel supportFor(@Nonnull Database database) {
            return SUPPORTED_VERSIONS.contains(database.getMajorVersion()) ? DatabaseSupportLevel.SUPPORTED : DatabaseSupportLevel.UNKNOWN;
        }
    }

    private static class PostgresSupportLevel
    extends AbstractSupportLevel {
        private static final Version POSTGRES_8_2 = new Version(new Integer[]{8, 2});
        private static final Version POSTGRES_9_4 = new Version(new Integer[]{9, 4});

        public PostgresSupportLevel() {
            super(DbType.POSTGRES);
        }

        @Override
        @Nonnull
        protected DatabaseSupportLevel supportFor(@Nonnull Database database) {
            return PostgresSupportLevel.between(database.getVersion(), POSTGRES_8_2, POSTGRES_9_4) ? DatabaseSupportLevel.SUPPORTED : DatabaseSupportLevel.UNKNOWN;
        }

        private static boolean between(Version version, Version lower, Version upper) {
            return version.compareTo(lower) > -1 && version.compareTo(upper) < 0;
        }
    }

    private static class OracleSupportLevel
    extends AbstractSupportLevel {
        private static final Set<Integer> SUPPORTED_VERSIONS = ImmutableSet.of((Object)11, (Object)12);

        public OracleSupportLevel() {
            super(DbType.ORACLE);
        }

        @Override
        @Nonnull
        protected DatabaseSupportLevel supportFor(@Nonnull Database database) {
            return SUPPORTED_VERSIONS.contains(database.getMajorVersion()) ? DatabaseSupportLevel.SUPPORTED : DatabaseSupportLevel.UNKNOWN;
        }
    }

    private static class MySqlSupportLevel
    extends AbstractSupportLevel {
        public MySqlSupportLevel() {
            super(DbType.MYSQL);
        }

        @Override
        @Nonnull
        protected DatabaseSupportLevel supportFor(@Nonnull Database database) {
            if (database.getMajorVersion() == 5) {
                int minor = database.getMinorVersion();
                if (minor == 0) {
                    return DatabaseSupportLevel.UNKNOWN;
                }
                if (minor == 1 || minor == 5 || minor == 6 && database.getPatchVersion() >= 16) {
                    return DatabaseSupportLevel.SUPPORTED;
                }
            }
            return DatabaseSupportLevel.UNSUPPORTED;
        }
    }

    private static class HsqlSupportLevel
    extends AbstractSupportLevel {
        public HsqlSupportLevel() {
            super(null);
        }

        @Override
        @Nonnull
        protected DatabaseSupportLevel supportFor(@Nonnull Database database) {
            return DatabaseSupportLevel.SUPPORTED;
        }
    }

    private static abstract class AbstractSupportLevel
    implements Function<Database, DetailedDatabase> {
        private final DbType type;

        protected AbstractSupportLevel(DbType type) {
            this.type = type;
        }

        public DetailedDatabase apply(Database database) {
            return new DelegatingDetailedDatabase(database, this.supportFor(database), this.type);
        }

        @Nonnull
        protected abstract DatabaseSupportLevel supportFor(@Nonnull Database var1);
    }
}

