/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.content;

import com.atlassian.stash.idx.IndexSearchRequest;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.content.IndexedChangesetDao;
import com.atlassian.stash.internal.idx.InternalChangesetAttribute;
import com.atlassian.stash.internal.idx.InternalIndexedChangeset;
import com.atlassian.stash.internal.idx.InternalRepositoryMembership;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.property.PropertyMap;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="indexedChangesetDao")
public class HibernateIndexedChangesetDao
extends AbstractHibernateDao<String, InternalIndexedChangeset>
implements IndexedChangesetDao {
    @Autowired
    public HibernateIndexedChangesetDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public boolean addMembership(@Nonnull InternalIndexedChangeset changeset, @Nonnull InternalRepository repository) {
        InternalRepositoryMembership membership = this.getMembership(changeset.getId(), repository);
        if (membership == null) {
            this.session().save((Object)new InternalRepositoryMembership(changeset, repository));
            return true;
        }
        return false;
    }

    public boolean addProperty(@Nonnull InternalIndexedChangeset changeset, @Nonnull String key, @Nonnull String value) {
        boolean result = changeset.addAttribute(new InternalChangesetAttribute(key, value));
        this.session().update((Object)changeset);
        return result;
    }

    public void deleteAllMemberships(@Nonnull InternalRepository repository) {
        this.session().createQuery("DELETE from InternalRepositoryMembership where repository = :repositoryId").setParameter("repositoryId", (Object)repository).executeUpdate();
    }

    public boolean deleteMembership(@Nonnull String changesetId, @Nonnull InternalRepository repository) {
        InternalRepositoryMembership membership = this.getMembership(changesetId, repository);
        if (membership != null) {
            this.session().delete((Object)membership);
            InternalIndexedChangeset changeset = membership.getChangeset();
            Set memberships = changeset.getRepositoryMemberships();
            memberships.remove(membership);
            if (memberships.isEmpty()) {
                this.delete(membership.getChangeset());
            }
            return true;
        }
        return false;
    }

    @Nonnull
    public List<InternalIndexedChangeset> findByProperty(String key, String value, boolean caseSensitive) {
        return HibernateUtils.initializeList((List)this.session().createQuery("FROM InternalIndexedChangeset cs JOIN cs.attributes att WITH " + (caseSensitive ? "att.value = :value " : "lower(att.value) = lower(:value) ") + " AND att.name = :name " + "ORDER BY cs.authorTimestamp DESC").setString("name", key).setString("value", value).list());
    }

    @Nonnull
    public PropertyMap getProperties(String changesetId, Iterable<String> propertyKeys) {
        if (changesetId == null || Iterables.isEmpty(propertyKeys)) {
            return PropertyMap.EMPTY;
        }
        List attributes = this.session().createQuery("SELECT new com.atlassian.stash.internal.idx.InternalChangesetAttribute(att.name, att.value) FROM InternalIndexedChangeset cs JOIN cs.attributes att WITH att.name IN (:names) WHERE cs.id = :id").setString("id", changesetId).setParameterList("names", HibernateIndexedChangesetDao.asSet(propertyKeys)).list();
        PropertyAccumulator properties = new PropertyAccumulator();
        for (InternalChangesetAttribute attribute : attributes) {
            properties.add(attribute.getName(), attribute.getValue());
        }
        return properties.toProperties();
    }

    @Nonnull
    public Map<String, PropertyMap> getProperties(Iterable<String> changesetIds, Iterable<String> propertyKeys) {
        if (Iterables.isEmpty(changesetIds) || Iterables.isEmpty(propertyKeys)) {
            return Collections.emptyMap();
        }
        List results = this.session().createQuery("SELECT cs.id, att.name, att.value FROM InternalIndexedChangeset cs JOIN cs.attributes att WITH att.name IN (:names) WHERE cs.id IN (:ids)").setParameterList("ids", HibernateIndexedChangesetDao.asSet(changesetIds)).setParameterList("names", HibernateIndexedChangesetDao.asSet(propertyKeys)).list();
        HashMap resultBuilder = Maps.newHashMap();
        for (Object[] row : results) {
            String csId = (String)row[0];
            String attName = (String)row[1];
            String attValue = (String)row[2];
            PropertyAccumulator properties = (PropertyAccumulator)resultBuilder.get(csId);
            if (properties == null) {
                properties = new PropertyAccumulator();
                resultBuilder.put(csId, properties);
            }
            properties.add(attName, attValue);
        }
        return ImmutableMap.copyOf((Map)Maps.transformValues((Map)resultBuilder, PropertyAccumulator.TO_PROPERTIES));
    }

    @Nonnull
    public Set<String> getPropertyValues(String changesetId, String key) {
        PropertyMap result = this.getProperties(changesetId, Collections.singleton(key));
        return result.isEmpty() ? Collections.emptySet() : (Set)result.getAs(key, Set.class, String.class);
    }

    public boolean isMemberOf(@Nonnull String changesetId, @Nonnull InternalRepository repository) {
        return this.getMembership(changesetId, repository) != null;
    }

    public boolean removeProperty(@Nonnull String changesetId, @Nonnull String key, @Nonnull String value) {
        InternalIndexedChangeset changeset = (InternalIndexedChangeset)this.getById(changesetId);
        if (changeset != null) {
            boolean result = changeset.removeAttribute(new InternalChangesetAttribute(key, value));
            this.session().update((Object)changeset);
            return result;
        }
        return false;
    }

    @Nonnull
    public Page<InternalIndexedChangeset> search(@Nonnull IndexSearchRequest searchRequest, @Nonnull PageRequest pageRequest) {
        Criteria criteria = this.session().createCriteria(InternalIndexedChangeset.class);
        if (StringUtils.isNotEmpty((String)searchRequest.getFilter())) {
            criteria.add((Criterion)Restrictions.like((String)"id", (String)searchRequest.getFilter(), (MatchMode)MatchMode.START));
        }
        return HibernateUtils.initializePage(this.pageCriteria(criteria, pageRequest));
    }

    @Override
    public InternalIndexedChangeset update(InternalIndexedChangeset entity) {
        throw new UnsupportedOperationException("Indexed changesets can not be updated");
    }

    @Override
    protected Iterable<Order> getImplicitOrder() {
        return Arrays.asList(Order.desc((String)"authorTimestamp"), Order.desc((String)"id"));
    }

    private static Set<String> asSet(Iterable<String> values) {
        return values instanceof Set ? (Set)values : ImmutableSet.copyOf(values);
    }

    private InternalRepositoryMembership getMembership(@Nonnull String changesetId, @Nonnull InternalRepository repository) {
        return (InternalRepositoryMembership)this.session().get(InternalRepositoryMembership.class, (Serializable)new InternalRepositoryMembership.PK(changesetId, repository.getId().intValue()));
    }

    private static class PropertyAccumulator {
        static final Function<PropertyAccumulator, PropertyMap> TO_PROPERTIES = new Function<PropertyAccumulator, PropertyMap>(){

            public PropertyMap apply(PropertyAccumulator input) {
                return input.toProperties();
            }
        };
        private final Map<String, Set<String>> properties = new HashMap<String, Set<String>>();

        private PropertyAccumulator() {
        }

        public void add(String key, String value) {
            Set<String> values = this.properties.get(key);
            if (values == null) {
                values = new HashSet<String>();
                this.properties.put(key, values);
            }
            values.add(value);
        }

        public PropertyMap toProperties() {
            return new PropertyMap.Builder().properties(this.properties).build();
        }
    }
}

