/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext;

import java.text.ParseException;
import liquibase.database.Database;
import liquibase.database.structure.type.CharType;
import liquibase.database.structure.type.CustomType;
import liquibase.database.structure.type.DataType;
import liquibase.database.structure.type.VarcharType;
import liquibase.database.typeconversion.core.MSSQLTypeConverter;

public class CustomMSSQLTypeConverter
extends MSSQLTypeConverter {
    public int getPriority() {
        return 10;
    }

    public CharType getCharType() {
        return new CharType("NCHAR");
    }

    public VarcharType getVarcharType() {
        return new VarcharType("NVARCHAR");
    }

    protected DataType getDataType(String columnTypeString, Boolean autoIncrement, String dataTypeName, String precision, String additionalInformation) {
        DataType returnTypeName = super.getDataType(columnTypeString, autoIncrement, dataTypeName, precision, additionalInformation);
        if (returnTypeName instanceof CustomType) {
            boolean returnTypeChanged = false;
            if (columnTypeString.toUpperCase().startsWith("CHARACTER")) {
                returnTypeName = new CharType("NCHAR");
                returnTypeChanged = true;
            }
            if (returnTypeChanged) {
                this.addPrecisionToType(precision, returnTypeName);
            }
        }
        return returnTypeName;
    }

    protected Object convertToCorrectObjectType(String value, int dataType, int columnSize, int decimalDigits, Database database) throws ParseException {
        if (value == null) {
            return null;
        }
        if (dataType == 2011 || dataType == -9 || dataType == -15) {
            if (value.equalsIgnoreCase("NULL")) {
                return null;
            }
            return value;
        }
        return super.convertToCorrectObjectType(value, dataType, columnSize, decimalDigits, database);
    }
}

