/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.InternalRepositorySettings;
import com.atlassian.stash.internal.repository.RepositorySettingsDao;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Order;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="repositorySettingsDao")
public class HibernateRepositorySettingsDao
extends AbstractHibernateDao<Long, InternalRepositorySettings>
implements RepositorySettingsDao {
    @Autowired
    public HibernateRepositorySettingsDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Override
    protected Order getImplicitOrder() {
        return Order.asc((String)"id");
    }

    public InternalRepositorySettings findByKey(InternalRepository repository, String key) {
        return (InternalRepositorySettings)this.session().createQuery("from InternalRepositorySettings where repository = :repository and key = :key").setParameter("repository", Preconditions.checkNotNull((Object)repository, (Object)"repository")).setParameter("key", Preconditions.checkNotNull((Object)key, (Object)"key")).uniqueResult();
    }

    @Nonnull
    public Collection<String> findKeysWithSettings(@Nonnull InternalRepository repository, @Nonnull Collection<String> keys) {
        Preconditions.checkNotNull(keys, (Object)"keys");
        if (keys.isEmpty()) {
            return Collections.emptyList();
        }
        return this.session().createQuery("select key from InternalRepositorySettings where repository = :repository and key in :keys").setParameter("repository", Preconditions.checkNotNull((Object)repository, (Object)"repository")).setParameterList("keys", keys).list();
    }

    public Iterable<InternalRepositorySettings> findByRepository(InternalRepository repository, Collection<String> keys) {
        Preconditions.checkNotNull(keys, (Object)"keys");
        if (keys.isEmpty()) {
            return Collections.emptyList();
        }
        return this.session().createQuery("from InternalRepositorySettings where repository = :repository and key in :keys").setParameter("repository", Preconditions.checkNotNull((Object)repository, (Object)"repository")).setParameterList("keys", keys).list();
    }

    public void deleteByKey(InternalRepository repository, String key) {
        this.session().createQuery("delete from InternalRepositorySettings where repository = :repository and key = :key").setParameter("repository", Preconditions.checkNotNull((Object)repository, (Object)"repository")).setParameter("key", Preconditions.checkNotNull((Object)key, (Object)"key")).executeUpdate();
    }
}

