/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.liquibase;

import com.atlassian.core.db.JDBCUtils;
import com.atlassian.stash.internal.liquibase.AbstractCustomChange;
import com.atlassian.stash.internal.liquibase.LiquibaseUtils;
import com.google.common.collect.Maps;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import liquibase.change.custom.CustomTaskChange;
import liquibase.change.custom.CustomTaskRollback;
import liquibase.database.Database;
import liquibase.exception.CustomChangeException;
import liquibase.exception.RollbackImpossibleException;
import liquibase.exception.UnsupportedChangeException;
import org.apache.commons.codec.binary.Base64;

public class BlobBase64EncodeChange
extends AbstractCustomChange
implements CustomTaskChange,
CustomTaskRollback {
    private String tableName;
    private String primaryKey;
    private String fromColumnName;
    private String toColumnName;
    private int charLimit = -1;

    public void execute(Database database) throws CustomChangeException {
        Map<Integer, String> data = this.selectData(database);
        this.updateTable(database, data);
    }

    private Map<Integer, String> selectData(Database database) throws CustomChangeException {
        HashMap data = Maps.newHashMap();
        Statement statement = null;
        ResultSet rs = null;
        try {
            Connection connection = LiquibaseUtils.getConnection(database);
            statement = connection.createStatement();
            rs = statement.executeQuery(String.format("SELECT %s, %s FROM %s", database.escapeColumnName(null, this.tableName, this.primaryKey), database.escapeColumnName(null, this.tableName, this.fromColumnName), database.escapeTableName(null, this.tableName)));
            while (rs.next()) {
                String transformedValue;
                long blobLength;
                int key = rs.getInt(this.primaryKey);
                Blob blob = rs.getBlob(this.fromColumnName);
                byte[] value = blob.getBytes(1L, (int)(blobLength = blob.length()));
                String string = transformedValue = value != null ? new String(Base64.encodeBase64((byte[])value)) : null;
                if (this.charLimit > 0 && transformedValue != null && transformedValue.length() > this.charLimit) {
                    throw new CustomChangeException(String.format("Failed to transform unbound BLOB on column %s to base64 bound char limit of %d on %s in table %s, key: %d", this.fromColumnName, this.charLimit, this.toColumnName, this.tableName, key));
                }
                data.put(key, transformedValue);
            }
        }
        catch (SQLException e) {
            try {
                throw new CustomChangeException(String.format("Failed to select data from %s", this.tableName), (Throwable)e);
            }
            catch (Throwable throwable) {
                JDBCUtils.close(rs);
                JDBCUtils.close((Statement)statement);
                throw throwable;
            }
        }
        JDBCUtils.close((ResultSet)rs);
        JDBCUtils.close((Statement)statement);
        return data;
    }

    private void updateTable(Database database, Map<Integer, String> data) throws CustomChangeException {
        if (data.isEmpty()) {
            return;
        }
        PreparedStatement statement = null;
        try {
            Connection connection = LiquibaseUtils.getConnection(database);
            statement = connection.prepareStatement(String.format("UPDATE %s SET %s = ? WHERE %s = ?", database.escapeTableName(null, this.tableName), database.escapeColumnName(null, this.tableName, this.toColumnName), database.escapeColumnName(null, this.tableName, this.primaryKey)));
            for (Map.Entry<Integer, String> entry : data.entrySet()) {
                statement.setString(1, entry.getValue());
                statement.setInt(2, entry.getKey());
                statement.addBatch();
            }
            statement.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new CustomChangeException(String.format("Failed to update data in %s", this.tableName), (Throwable)e);
            }
            catch (Throwable throwable) {
                JDBCUtils.close(statement);
                throw throwable;
            }
        }
        JDBCUtils.close((Statement)statement);
    }

    public void rollback(Database database) throws CustomChangeException, UnsupportedChangeException, RollbackImpossibleException {
        PreparedStatement statement = null;
        try {
            Connection connection = LiquibaseUtils.getConnection(database);
            statement = connection.prepareStatement(String.format("UPDATE %s SET %s = NULL", database.escapeTableName(null, this.tableName), database.escapeColumnName(null, this.tableName, this.toColumnName)));
            statement.execute();
        }
        catch (SQLException e) {
            try {
                throw new CustomChangeException(String.format("Failed to rollback data in %s", this.tableName), (Throwable)e);
            }
            catch (Throwable throwable) {
                JDBCUtils.close(statement);
                throw throwable;
            }
        }
        JDBCUtils.close((Statement)statement);
    }

    public String getConfirmationMessage() {
        return String.format("Converted blob data in %1$s.%2$s to base64 data in %1$s.%3$s", this.tableName, this.fromColumnName, this.toColumnName);
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setFromColumnName(String fromColumnName) {
        this.fromColumnName = fromColumnName;
    }

    public void setToColumnName(String toColumnName) {
        this.toColumnName = toColumnName;
    }

    public void setCharLimit(Integer charLimit) {
        this.charLimit = charLimit;
    }
}

