/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook.repository;

import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.hook.repository.InternalRepositoryHookStatus;
import com.atlassian.stash.internal.hook.repository.RepositoryHookStatusDao;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Order;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="repositoryHookStatusDao")
public class HibernateRepositoryHookStatusDao
extends AbstractHibernateDao<Long, InternalRepositoryHookStatus>
implements RepositoryHookStatusDao {
    @Autowired
    public HibernateRepositoryHookStatusDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Override
    protected Order getImplicitOrder() {
        return Order.asc((String)"id").ignoreCase();
    }

    public List<InternalRepositoryHookStatus> findEnabledHooks(InternalRepository repository, Collection<String> keys) {
        if (keys.isEmpty()) {
            return Collections.emptyList();
        }
        return this.session().createQuery("from InternalRepositoryHookStatus where repository = :repository and key in :keys and enabled = true").setParameter("repository", Preconditions.checkNotNull((Object)repository)).setParameterList("keys", keys).list();
    }

    public InternalRepositoryHookStatus findHook(@Nonnull InternalRepository repository, @Nonnull String key) {
        return (InternalRepositoryHookStatus)this.session().createQuery("from InternalRepositoryHookStatus where repository = :repository and key = :key").setParameter("repository", Preconditions.checkNotNull((Object)repository)).setParameter("key", Preconditions.checkNotNull((Object)key)).uniqueResult();
    }
}

