/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.content;

import com.atlassian.stash.content.AttributeMap;
import com.atlassian.stash.idx.IndexSearchRequest;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.content.IndexedChangesetDao;
import com.atlassian.stash.internal.idx.InternalChangesetAttribute;
import com.atlassian.stash.internal.idx.InternalIndexedChangeset;
import com.atlassian.stash.internal.idx.InternalRepositoryMembership;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="indexedChangesetDao")
public class HibernateIndexedChangesetDao
extends AbstractHibernateDao<String, InternalIndexedChangeset>
implements IndexedChangesetDao {
    @Autowired
    public HibernateIndexedChangesetDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public boolean addAttribute(@Nonnull InternalIndexedChangeset changeset, @Nonnull String attribute, @Nonnull String value) {
        boolean result = changeset.addAttribute(new InternalChangesetAttribute(attribute, value));
        this.session().update((Object)changeset);
        return result;
    }

    public boolean addMembership(@Nonnull InternalIndexedChangeset changeset, @Nonnull InternalRepository repository) {
        InternalRepositoryMembership membership = this.getMembership(changeset.getId(), repository);
        if (membership == null) {
            this.session().save((Object)new InternalRepositoryMembership(changeset, repository));
            return true;
        }
        return false;
    }

    public void deleteAllMemberships(@Nonnull InternalRepository repository) {
        this.session().createQuery("DELETE from InternalRepositoryMembership where repository = :repositoryId").setParameter("repositoryId", (Object)repository).executeUpdate();
    }

    public boolean deleteMembership(@Nonnull String changesetId, @Nonnull InternalRepository repository) {
        InternalRepositoryMembership membership = this.getMembership(changesetId, repository);
        if (membership != null) {
            this.session().delete((Object)membership);
            InternalIndexedChangeset changeset = membership.getChangeset();
            Set memberships = changeset.getRepositoryMemberships();
            memberships.remove(membership);
            if (memberships.isEmpty()) {
                this.delete(membership.getChangeset());
            }
            return true;
        }
        return false;
    }

    @Nonnull
    public List<InternalIndexedChangeset> findByAttribute(@Nonnull String attributeName, @Nonnull String attributeValue, boolean caseSensitive) {
        return HibernateUtils.initializeList((List)this.session().createQuery("FROM InternalIndexedChangeset cs JOIN cs.attributes att WITH " + (caseSensitive ? "att.value = :value " : "lower(att.value) = lower(:value) ") + " AND att.name = :name " + "ORDER BY cs.authorTimestamp DESC").setString("name", attributeName).setString("value", attributeValue).list());
    }

    @Nonnull
    public Set<String> getAttributeValues(String changesetId, String attributeName) {
        AttributeMap result = this.getAttributesForChangeset(changesetId, Collections.singleton(attributeName));
        return result.isEmpty() ? Collections.emptySet() : result.get((Object)attributeName);
    }

    @Nonnull
    public AttributeMap getAttributesForChangeset(String changesetId, Collection<String> attributeNames) {
        if (changesetId == null || CollectionUtils.isEmpty(attributeNames)) {
            return AttributeMap.EMPTY;
        }
        List attributes = this.session().createQuery("SELECT new com.atlassian.stash.internal.idx.InternalChangesetAttribute(att.name, att.value) FROM InternalIndexedChangeset cs JOIN cs.attributes att WITH att.name IN (:names) WHERE cs.id = :id").setString("id", changesetId).setParameterList("names", attributeNames).list();
        AttributeMap.Builder attributeMap = new AttributeMap.Builder();
        for (InternalChangesetAttribute attribute : attributes) {
            attributeMap.add(attribute.getName(), new String[]{attribute.getValue()});
        }
        return attributeMap.build();
    }

    @Nonnull
    public Map<String, AttributeMap> getAttributesForChangesets(Collection<String> changesetIds, Collection<String> attributeNames) {
        if (CollectionUtils.isEmpty(changesetIds) || CollectionUtils.isEmpty(attributeNames)) {
            return Collections.emptyMap();
        }
        List results = this.session().createQuery("SELECT cs.id, att.name, att.value FROM InternalIndexedChangeset cs JOIN cs.attributes att WITH att.name IN (:names) WHERE cs.id IN (:ids)").setParameterList("ids", changesetIds).setParameterList("names", attributeNames).list();
        HashMap resultBuilder = Maps.newHashMap();
        for (Object[] row : results) {
            String csId = (String)row[0];
            String attName = (String)row[1];
            String attValue = (String)row[2];
            AttributeMap.Builder attributeMap = (AttributeMap.Builder)resultBuilder.get(csId);
            if (attributeMap == null) {
                attributeMap = new AttributeMap.Builder();
                resultBuilder.put(csId, attributeMap);
            }
            attributeMap.add(attName, new String[]{attValue});
        }
        HashMap<String, AttributeMap> result = new HashMap<String, AttributeMap>(resultBuilder.size());
        for (Map.Entry entry : resultBuilder.entrySet()) {
            result.put((String)entry.getKey(), ((AttributeMap.Builder)entry.getValue()).build());
        }
        return result;
    }

    public boolean isMemberOf(@Nonnull String changesetId, @Nonnull InternalRepository repository) {
        return this.getMembership(changesetId, repository) != null;
    }

    public boolean removeAttribute(@Nonnull String changesetId, @Nonnull String attribute, @Nonnull String value) {
        InternalIndexedChangeset changeset = (InternalIndexedChangeset)this.getById(changesetId);
        if (changeset != null) {
            boolean result = changeset.removeAttribute(new InternalChangesetAttribute(attribute, value));
            this.session().update((Object)changeset);
            return result;
        }
        return false;
    }

    @Nonnull
    public Page<InternalIndexedChangeset> search(@Nonnull IndexSearchRequest searchRequest, @Nonnull PageRequest pageRequest) {
        Criteria criteria = this.session().createCriteria(InternalIndexedChangeset.class);
        if (StringUtils.isNotEmpty((String)searchRequest.getFilter())) {
            criteria.add((Criterion)Restrictions.like((String)"id", (String)searchRequest.getFilter(), (MatchMode)MatchMode.START));
        }
        return HibernateUtils.initializePage(this.pageCriteria(criteria, pageRequest));
    }

    @Override
    public InternalIndexedChangeset update(InternalIndexedChangeset entity) {
        throw new UnsupportedOperationException("Indexed changesets can not be updated");
    }

    @Override
    protected Order getImplicitOrder() {
        return Order.desc((String)"authorTimestamp");
    }

    private InternalRepositoryMembership getMembership(@Nonnull String changesetId, @Nonnull InternalRepository repository) {
        return (InternalRepositoryMembership)this.session().get(InternalRepositoryMembership.class, (Serializable)new InternalRepositoryMembership.PK(changesetId, repository.getId().intValue()));
    }
}

