/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.backup.liquibase;

import com.atlassian.fugue.Effect;
import com.atlassian.fugue.Option;
import com.atlassian.stash.internal.backup.liquibase.ChangeLogOutline;
import com.atlassian.stash.internal.backup.liquibase.ColumnParsingContext;
import com.atlassian.stash.internal.backup.liquibase.ColumnSerialisationType;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseChangeSet;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseChangeSetMetaData;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseDao;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseRestoreMonitor;
import com.atlassian.stash.internal.backup.liquibase.xml.XmlEncoder;
import com.atlassian.stash.util.CancelState;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import liquibase.change.core.DeleteDataChange;
import liquibase.change.core.InsertDataChange;
import liquibase.changelog.ChangeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class DatabaseUpdater
extends DefaultHandler {
    private static final Logger log = LoggerFactory.getLogger(DatabaseUpdater.class);
    private final CancelState cancelState;
    private final LiquibaseDao dao;
    private final LiquibaseRestoreMonitor monitor;
    private final Iterator<LiquibaseChangeSetMetaData> outline;
    private final int totalNonEmptyChangesetCount;
    private final XmlEncoder xmlEncoder;
    private ChangeSet changeSet;
    private int changeSetCount;
    private DeleteDataChange deleteDataChange;
    private InsertDataChange insertDataChange;
    private Option<ColumnParsingContext> columnContextOption = Option.none();

    DatabaseUpdater(CancelState cancelState, LiquibaseDao dao, LiquibaseRestoreMonitor monitor, ChangeLogOutline outline, XmlEncoder xmlEncoder) {
        this.cancelState = cancelState;
        this.dao = (LiquibaseDao)Preconditions.checkNotNull((Object)dao);
        this.monitor = (LiquibaseRestoreMonitor)Preconditions.checkNotNull((Object)monitor);
        this.outline = outline.iterator();
        this.totalNonEmptyChangesetCount = outline.nonEmptyChangeSetCount();
        this.xmlEncoder = (XmlEncoder)Preconditions.checkNotNull((Object)xmlEncoder);
    }

    @Override
    public void characters(final char[] ch, final int start, final int length) throws SAXException {
        if (!this.cancelState.isCanceled()) {
            this.columnContextOption.foreach((Effect)new Effect<ColumnParsingContext>(){

                public void apply(ColumnParsingContext context) {
                    context.append(ch, start, length);
                }
            });
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.cancelState.isCanceled()) {
            return;
        }
        if (this.changeSet != null && "changeSet".equals(qName)) {
            this.dao.endChangeSet();
            this.monitor.onFinishedChangeset();
            this.changeSet = null;
        } else if (this.columnContextOption.isDefined() && "column".equals(qName)) {
            this.insertDataChange.addColumn(((ColumnParsingContext)this.columnContextOption.get()).asColumnConfig(this.xmlEncoder));
            this.columnContextOption = Option.none();
        } else if (this.insertDataChange != null && "insert".equals(qName)) {
            if (this.insertDataChange.getColumns().size() > 0) {
                this.dao.insert(this.insertDataChange);
                this.insertDataChange = null;
                this.monitor.onAppliedChange();
            }
        } else if (this.deleteDataChange != null && "delete".equals(qName)) {
            this.dao.deleteAllRows(this.deleteDataChange.getTableName());
            this.deleteDataChange = null;
            this.monitor.onAppliedChange();
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.cancelState.isCanceled()) {
            return;
        }
        if (this.changeSet == null && "changeSet".equals(qName)) {
            LiquibaseChangeSetMetaData summary;
            if (this.outline.hasNext() && (summary = this.outline.next()).getChangeCount() > 0L) {
                this.changeSet = this.newChangeSet(attributes);
                log.debug("Executing changeset {} of {}, containing {} changes with id {}", new Object[]{this.changeSetCount, this.totalNonEmptyChangesetCount, summary.getChangeCount(), this.changeSet.getId()});
                ++this.changeSetCount;
                this.monitor.onBeginChangeset((LiquibaseChangeSet)summary, this.changeSetCount, this.totalNonEmptyChangesetCount);
                this.dao.beginChangeSet();
            }
        } else if (this.changeSet != null && this.insertDataChange == null && "insert".equals(qName)) {
            this.insertDataChange = new InsertDataChange();
            this.insertDataChange.setTableName(attributes.getValue("tableName"));
        } else if (this.changeSet != null && this.deleteDataChange == null && "delete".equals(qName)) {
            this.deleteDataChange = new DeleteDataChange();
            this.deleteDataChange.setTableName(attributes.getValue("tableName"));
        } else if (this.insertDataChange != null && "column".equals(qName)) {
            String columnName = attributes.getValue("name");
            ColumnSerialisationType columnSerialisationType = (ColumnSerialisationType)((Object)ColumnSerialisationType.fromString(attributes.getValue("colType")).get());
            this.columnContextOption = Option.some((Object)new ColumnParsingContext(columnName, columnSerialisationType));
        }
    }

    private ChangeSet newChangeSet(Attributes attributes) {
        boolean alwaysRun = false;
        boolean runOnChange = false;
        boolean runInTxn = false;
        String filePath = "restore";
        String id = attributes.getValue("id");
        String author = attributes.getValue("author");
        String contextString = attributes.getValue("context");
        String dbms = attributes.getValue("dbms");
        return new ChangeSet(id, author, alwaysRun, runOnChange, filePath, contextString, dbms, runInTxn);
    }
}

