/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.database.AbstractDatabase;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.integration.spring.SpringLiquibase;
import liquibase.lockservice.LockService;
import liquibase.logging.LogFactory;
import org.springframework.jdbc.support.JdbcUtils;

public class DefaultingSchemaLiquibase
extends SpringLiquibase {
    private long lockMaxWait;
    private long lockPollInterval;

    public DefaultingSchemaLiquibase(DataSource dataSource) {
        this.setDataSource(dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws LiquibaseException {
        String shouldRunProperty = System.getProperty("liquibase.should.run");
        if (shouldRunProperty != null && !Boolean.valueOf(shouldRunProperty).booleanValue()) {
            LogFactory.getLogger().info("Liquibase did not run because 'liquibase.should.run' system property was set to false");
            return;
        }
        Connection c = null;
        try {
            c = this.getDataSource().getConnection();
            Liquibase liquibase = this.createLiquibase(c);
            this.performUpdate(liquibase);
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
        finally {
            if (c != null) {
                try {
                    c.rollback();
                }
                catch (SQLException e) {
                }
                finally {
                    JdbcUtils.closeConnection((Connection)c);
                }
            }
        }
    }

    public void setLockMaxWait(long lockMaxWait) {
        this.lockMaxWait = TimeUnit.SECONDS.toMillis(Math.max(1L, lockMaxWait));
    }

    public void setLockPollInterval(long lockPollInterval) {
        this.lockPollInterval = TimeUnit.SECONDS.toMillis(Math.max(1L, lockPollInterval));
    }

    protected Database createDatabase(Connection c) throws DatabaseException {
        Database database = super.createDatabase(c);
        if (database instanceof AbstractDatabase) {
            database.setDefaultSchemaName(((AbstractDatabase)database).getDefaultDatabaseSchemaName());
        }
        LockService lockService = LockService.getInstance((Database)database);
        lockService.setChangeLogLockRecheckTime(this.lockPollInterval);
        lockService.setChangeLogLockWaitTime(this.lockMaxWait);
        return database;
    }

    protected void performUpdate(Liquibase liquibase) throws LiquibaseException {
        super.performUpdate(liquibase);
        Database database = liquibase.getDatabase();
        if (!database.isAutoCommit()) {
            database.setAutoCommit(true);
        }
    }
}

