/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.stash.experimental.user.ProjectPermission;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.hibernate.HibernatePageUtils;
import com.atlassian.stash.internal.user.AbstractHibernateGrantedPermissionDao;
import com.atlassian.stash.internal.user.InternalGrantedPermission;
import com.atlassian.stash.internal.user.InternalProjectPermission;
import com.atlassian.stash.internal.user.ProjectPermissionDao;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermittedGroup;
import com.atlassian.stash.user.PermittedUser;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.UserType;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="grantedProjectPermissionDao")
public class HibernateProjectPermissionDao
extends AbstractHibernateGrantedPermissionDao<InternalProjectPermission>
implements ProjectPermissionDao {
    @Autowired
    public HibernateProjectPermissionDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public Page<InternalProjectPermission> findDefaultPermissions(@Nonnull PageRequest pageRequest) {
        Query query = this.session().createQuery("from InternalProjectPermission where group is null and user is null");
        return HibernatePageUtils.pageQuery(query, pageRequest);
    }

    @Nonnull
    public Page<PermittedUser> findHighestPermissionPerUser(int projectId, @Nonnull UserType userType, @Nullable String filter, @Nonnull PageRequest pageRequest) {
        Page<StashUser> page = this.findUsersWithPermission(userType, filter, pageRequest, this.projectIdEq(projectId));
        if (page.getIsLastPage() && page.getSize() == 0) {
            return HibernatePageUtils.createEmptyPage((PageRequest)pageRequest);
        }
        Query query = this.createFindHighestPermissionPerUserQuery(page, "project.id = :projectId").setInteger("projectId", projectId);
        return this.pairUsersWithPermissions(page, query);
    }

    @Nonnull
    public Page<StashUser> findUsersWithPermission(int projectId, @Nonnull UserType userType, @Nonnull PageRequest pageRequest) {
        return this.findUsersWithPermission(userType, null, pageRequest, this.projectIdEq(projectId));
    }

    @Nonnull
    public Page<PermittedGroup> findHighestPermissionPerGroup(int projectId, @Nullable String filter, @Nonnull PageRequest pageRequest) {
        Query query = this.createFindHighestPermissionPerGroupQuery(filter, "project.id = :projectId").setInteger("projectId", projectId);
        return HibernatePageUtils.pageQuery(query, pageRequest);
    }

    @Nonnull
    public Page<String> findGroupsWithPermission(int projectId, @Nonnull PageRequest pageRequest) {
        return this.findGroupsWithPermission(pageRequest, this.projectIdEq(projectId));
    }

    public int revoke(@Nonnull InternalProjectPermission grantedPermission) {
        return this.createRevokeQuery((InternalGrantedPermission)grantedPermission, "project.id = :projectId").setInteger("projectId", grantedPermission.getProject().getId().intValue()).executeUpdate();
    }

    @Nullable
    public Permission getHighestPermissionForUser(int userId, int projectId) {
        Query query = this.session().createQuery("select max(t.weight) from InternalProjectPermission p, InternalPermissionType t where p.permission = t.id and p.project.id = :projectId and p.group is null and p.user.id = :userId").setParameter("userId", (Object)userId).setParameter("projectId", (Object)projectId);
        Integer maxWeight = (Integer)query.uniqueResult();
        return maxWeight == null ? null : Permission.fromWeight((int)maxWeight);
    }

    @Nonnull
    public Page<ProjectPermission> findHighestPermissionsForUser(int userId, @Nonnull PageRequest pageRequest) {
        Query query = this.session().createQuery("select new com.atlassian.stash.internal.user.InternalGrantedProjectPermission(pj, max(t.weight)) from InternalProjectPermission p, InternalPermissionType t, InternalProject pj where p.permission = t.id and p.project.id = pj.id and p.group is null and p.user.id = :userId group by pj.id, pj.name order by pj.name").setParameter("userId", (Object)userId);
        return HibernateUtils.initializePage(HibernatePageUtils.pageQuery(query, pageRequest));
    }

    @Override
    protected Criteria createHasPermissionEntryCriteria(InternalProjectPermission grantedPermission) {
        return super.createHasPermissionEntryCriteria(grantedPermission).add((Criterion)Restrictions.eq((String)"project", (Object)grantedPermission.getProject()));
    }

    @Override
    protected Order getImplicitOrder() {
        return Order.asc((String)"id");
    }

    private Criterion projectIdEq(int projectId) {
        return Restrictions.eq((String)"project.id", (Object)projectId);
    }
}

