/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.stash.comment.CommentAction;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.commit.InternalCommitDiscussionCommentActivity;
import com.atlassian.stash.internal.repository.InternalRepositoryActivity;
import com.atlassian.stash.internal.repository.RepositoryActivityDao;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="repositoryActivityDao")
public class HibernateRepositoryActivityDao
extends AbstractHibernateDao<Long, InternalRepositoryActivity>
implements RepositoryActivityDao {
    @Autowired
    public HibernateRepositoryActivityDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Nonnull
    public Map<String, Long> countCommentsByCommit(int repositoryId, @Nonnull Set<String> commitIds) {
        if (commitIds.isEmpty()) {
            return Collections.emptyMap();
        }
        List results = this.session().createQuery("select d.commitId, count(*) from InternalCommitDiscussionCommentActivity a join a.discussion d where d.repository.id = :repositoryId and d.commitId in (:commitIds) and a.commentAction in (:actions) group by d.commitId").setInteger("repositoryId", repositoryId).setParameterList("commitIds", commitIds).setParameterList("actions", EnumSet.of(CommentAction.ADDED, CommentAction.REPLIED)).list();
        HashMap<String, Long> counts = new HashMap<String, Long>(results.size(), 1.0f);
        for (Object result : results) {
            Object[] columns = (Object[])result;
            counts.put((String)columns[0], (Long)columns[1]);
        }
        return counts;
    }

    public void deleteByComment(long commentId) {
        this.session().createQuery("delete from InternalCommitDiscussionCommentActivity where comment.id = :commentId").setLong("commentId", commentId).executeUpdate();
    }

    public InternalCommitDiscussionCommentActivity findByComment(long commentId) {
        return (InternalCommitDiscussionCommentActivity)HibernateUtils.initialize((Object)((InternalCommitDiscussionCommentActivity)this.session().createCriteria(InternalCommitDiscussionCommentActivity.class).add((Criterion)Restrictions.eq((String)"comment.id", (Object)commentId)).add((Criterion)Restrictions.eq((String)"commentAction", (Object)CommentAction.ADDED)).uniqueResult()));
    }

    @Nonnull
    public Page<InternalRepositoryActivity> findByRepository(int repositoryId, @Nonnull PageRequest pageRequest) {
        return HibernateUtils.initializePage(this.getPageOfActivites(repositoryId, pageRequest));
    }

    @Override
    public InternalRepositoryActivity update(InternalRepositoryActivity entity) {
        throw new UnsupportedOperationException("RepositoryActivities are immutable and cannot be updated.");
    }

    @Override
    protected Order getImplicitOrder() {
        return Order.desc((String)"createdDate");
    }

    private Page<InternalRepositoryActivity> getPageOfActivites(int repositoryId, PageRequest pageRequest) {
        Criteria criteria = this.session().createCriteria(InternalRepositoryActivity.class).add((Criterion)Restrictions.eq((String)"repository.id", (Object)repositoryId)).add(Restrictions.not((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"type", (Object)5), (Criterion)Restrictions.ne((String)"commentAction", (Object)CommentAction.ADDED)))).addOrder(this.getImplicitOrder());
        return this.pageCriteria(criteria, pageRequest);
    }
}

