/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestRef;
import com.atlassian.stash.internal.pull.PullRequestDao;
import com.atlassian.stash.internal.pull.PullRequestSearchCriteria;
import com.atlassian.stash.internal.repository.RepositoryScopedIdGenerator;
import com.atlassian.stash.pull.PullRequestOrder;
import com.atlassian.stash.pull.PullRequestRole;
import com.atlassian.stash.pull.PullRequestState;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="pullRequestDao")
public class HibernatePullRequestDao
extends AbstractHibernateDao<Long, InternalPullRequest>
implements PullRequestDao {
    private final RepositoryScopedIdGenerator idGenerator;

    @Autowired
    public HibernatePullRequestDao(SessionFactory sessionFactory, RepositoryScopedIdGenerator idGenerator) {
        super(sessionFactory);
        this.idGenerator = idGenerator;
    }

    public long countMatching(@Nonnull PullRequestSearchCriteria searchCriteria) {
        return HibernateUtils.count((Criteria)this.createCriteria(searchCriteria).setCacheable(true).setCacheRegion("query.pullRequestCountByUser"));
    }

    @Override
    public InternalPullRequest create(InternalPullRequest entity) {
        if (entity.getScopedId() == null) {
            long scopedId = this.idGenerator.nextId(entity.getScopeRepository().getId().intValue(), entity.getScopeType());
            entity.setScopedId(scopedId);
        }
        return super.create(entity);
    }

    public int declineByFromRepository(int repositoryId) {
        return this.session().createQuery("update InternalPullRequest set state = :declined where fromRef.repository.id = :repoId and state = :open").setInteger("repoId", repositoryId).setParameter("declined", (Object)PullRequestState.DECLINED).setParameter("open", (Object)PullRequestState.OPEN).executeUpdate();
    }

    @Override
    public void delete(InternalPullRequest entity) {
        long globalId = entity.getGlobalId();
        Session session = this.session();
        session.createQuery("delete from InternalWatcher where watchable.id = :prId and watchable.class = :typeId").setLong("prId", globalId).setInteger("typeId", 1).executeUpdate();
        List commentIds = session.createQuery("select distinct comment.id from InternalPullRequestCommentActivity where pullRequest.id = :prId").setLong("prId", globalId).list();
        this.deleteActivitiesByPullRequest(globalId);
        this.deleteComments(commentIds);
        session.flush();
        super.delete(entity);
    }

    public int deleteByToRepository(int repositoryId) {
        Session session = this.session();
        session.createQuery("delete from InternalWatcher where watchable.id in (select id from InternalPullRequest where toRef.repository.id = :repoId) and watchable.class = :typeId").setInteger("repoId", repositoryId).setInteger("typeId", 1).executeUpdate();
        List commentIds = session.createQuery("select distinct comment.id from InternalPullRequestCommentActivity where pullRequest.toRef.repository.id = :repoId order by comment.id desc").setInteger("repoId", repositoryId).list();
        this.deleteActivitiesByToRepository(repositoryId);
        this.deleteComments(commentIds);
        int updated = session.createQuery("delete from InternalPullRequest where toRef.repository.id = :repoId").setInteger("repoId", repositoryId).executeUpdate();
        session.flush();
        return updated;
    }

    public InternalPullRequest findByRepositoryScopedId(int repositoryId, long pullRequestId) {
        Query query = this.session().createQuery("from InternalPullRequest where toRef.repository.id = :repositoryId and scopedId = :pullRequestId").setParameter("repositoryId", (Object)repositoryId).setParameter("pullRequestId", (Object)pullRequestId);
        return (InternalPullRequest)HibernateUtils.initialize((Object)((InternalPullRequest)query.uniqueResult()));
    }

    public InternalPullRequest findByRefs(@Nonnull InternalPullRequestRef from, @Nonnull InternalPullRequestRef to) {
        Query query = this.session().createQuery("from InternalPullRequest where state = :state and fromRef.repository.id = :fromRepositoryId and fromRef.id = :fromBranchFqn and toRef.repository.id = :toRepositoryId and toRef.id = :toBranchFqn").setString("fromBranchFqn", from.getId()).setInteger("fromRepositoryId", from.getRepository().getId().intValue()).setString("toBranchFqn", to.getId()).setInteger("toRepositoryId", to.getRepository().getId().intValue()).setParameter("state", (Object)PullRequestState.OPEN);
        return (InternalPullRequest)HibernateUtils.initialize((Object)((InternalPullRequest)query.uniqueResult()));
    }

    @Nonnull
    public Page<InternalPullRequest> findUnmergedByFromRepository(int repositoryId, @Nonnull PageRequest pageRequest) {
        Criteria criteria = this.session().createCriteria(InternalPullRequest.class).add((Criterion)Restrictions.eq((String)"fromRef.repository.id", (Object)repositoryId)).add((Criterion)Restrictions.ne((String)"state", (Object)PullRequestState.MERGED)).addOrder(Order.asc((String)"id"));
        return this.pageCriteria(criteria, pageRequest);
    }

    @Override
    public InternalPullRequest getById(Long id) {
        return (InternalPullRequest)HibernateUtils.initialize(super.getById(id));
    }

    public int overwriteFromRepository(int repositoryId) {
        Session session = this.session();
        int updated = session.createQuery("update InternalPullRequest set fromRef.repository.id = toRef.repository.id where fromRef.repository.id = :repoId").setInteger("repoId", repositoryId).executeUpdate();
        session.flush();
        return updated;
    }

    @Nonnull
    public Page<InternalPullRequest> search(@Nonnull PullRequestSearchCriteria searchCriteria, @Nonnull PageRequest pageRequest, @Nonnull Predicate<? super InternalPullRequest> predicate) {
        Criteria criteria = this.createCriteria(searchCriteria).addOrder(this.chooseOrder(searchCriteria));
        return HibernateUtils.initializePage(this.pageCriteria(criteria, pageRequest, predicate));
    }

    @Override
    public InternalPullRequest update(InternalPullRequest entity) {
        return (InternalPullRequest)HibernateUtils.initialize((Object)super.update(entity));
    }

    @Override
    protected Order getImplicitOrder() {
        return this.getDescOrder();
    }

    private Order chooseOrder(PullRequestSearchCriteria searchCriteria) {
        if (searchCriteria.hasOrder()) {
            return searchCriteria.getOrder() == PullRequestOrder.OLDEST ? this.getAscOrder() : this.getDescOrder();
        }
        return this.getImplicitOrder();
    }

    private Criteria createCriteria(PullRequestSearchCriteria searchCriteria) {
        Criteria criteria = this.session().createCriteria(InternalPullRequest.class);
        if (searchCriteria.hasState()) {
            criteria.add((Criterion)Restrictions.eq((String)"state", (Object)searchCriteria.getState()));
        }
        if (searchCriteria.hasToRepositoryId()) {
            criteria.add((Criterion)Restrictions.eq((String)"toRef.repository.id", (Object)searchCriteria.getToRepositoryId()));
        }
        if (searchCriteria.hasFromRepositoryId()) {
            criteria.add((Criterion)Restrictions.eq((String)"fromRef.repository.id", (Object)searchCriteria.getFromRepositoryId()));
        }
        if (searchCriteria.hasFromRefIds()) {
            criteria.add(Restrictions.in((String)"fromRef.id", (Collection)searchCriteria.getFromRefIds()));
        }
        if (searchCriteria.hasToRefIds()) {
            criteria.add(Restrictions.in((String)"toRef.id", (Collection)searchCriteria.getToRefIds()));
        }
        if (searchCriteria.hasUserId()) {
            Criteria participantCriteria = criteria.createCriteria("participants").add((Criterion)Restrictions.eq((String)"user.id", (Object)searchCriteria.getUserId()));
            if (searchCriteria.hasParticipantRole()) {
                participantCriteria.add((Criterion)Restrictions.eq((String)"role", (Object)searchCriteria.getParticipantRole()));
                if (searchCriteria.getParticipantRole().equals((Object)PullRequestRole.REVIEWER) && searchCriteria.hasApproved()) {
                    participantCriteria.add((Criterion)Restrictions.eq((String)"approved", (Object)searchCriteria.getApproved()));
                }
            }
        }
        return criteria;
    }

    private void deleteActivitiesByPullRequest(long pullRequestId) {
        this.maybeBulkDelete("from InternalPullRequestActivity where pullRequest.id = :pullRequestId", (Map<String, Object>)ImmutableMap.of((Object)"pullRequestId", (Object)pullRequestId));
    }

    private void deleteActivitiesByToRepository(int repositoryId) {
        this.maybeBulkDelete("from InternalPullRequestActivity where pullRequest.id in (select id from InternalPullRequest where toRef.repository.id = :repositoryId)", (Map<String, Object>)ImmutableMap.of((Object)"repositoryId", (Object)repositoryId));
    }

    private void deleteComments(List<Long> commentIds) {
        if (commentIds.isEmpty()) {
            return;
        }
        for (List ids : Lists.partition(commentIds, (int)100)) {
            this.session().createQuery("delete from InternalComment where id in (:commentIds)").setParameterList("commentIds", (Collection)ids).executeUpdate();
        }
    }

    private Order getAscOrder() {
        return Order.asc((String)"updatedDate");
    }

    private Order getDescOrder() {
        return Order.desc((String)"updatedDate");
    }
}

