/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.stash.internal.plugin.PluginSetting;
import com.atlassian.stash.internal.plugin.PluginSettingDao;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="pluginSettingDao")
public class HibernatePluginSettingDao
implements PluginSettingDao {
    private final SessionFactory sessionFactory;

    @Autowired
    public HibernatePluginSettingDao(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    private Session session() {
        return this.sessionFactory.getCurrentSession();
    }

    public void put(String namespace, String key, String val) {
        Preconditions.checkNotNull((Object)namespace, (Object)key);
        this.session().merge((Object)new PluginSetting(namespace, key, val));
    }

    public String get(String namespace, String key) {
        if (namespace == null || key == null) {
            return null;
        }
        PluginSetting result = (PluginSetting)this.session().get(PluginSetting.class, (Serializable)new PluginSetting.CompositeKey(namespace, key));
        return result == null ? null : result.getValue();
    }

    public void remove(String namespace, String key) {
        if (namespace == null || key == null) {
            return;
        }
        PluginSetting result = (PluginSetting)this.session().get(PluginSetting.class, (Serializable)new PluginSetting.CompositeKey(namespace, key));
        if (result != null) {
            this.session().delete((Object)result);
        }
    }
}

