/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hibernate;

import com.atlassian.stash.internal.repository.RepositoryScopedIdGenerator;
import com.google.common.collect.ImmutableMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.jdbc.AbstractWork;
import org.hibernate.jdbc.WorkExecutorVisitable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.stereotype.Component;

@Component(value="repositoryScopedIdGenerator")
public class HibernateRepositoryScopedIdGenerator
implements RepositoryScopedIdGenerator {
    public static final String COLUMN_NEXT_ID = "next_id";
    public static final String COLUMN_REPOSITORY_ID = "repository_id";
    public static final String COLUMN_SCOPE_TYPE = "scope_type";
    public static final String TABLE_NAME = "sta_repository_scoped_id";
    private static final String ALIAS = "rsi";
    private static final String INSERT_SQL = "insert into sta_repository_scoped_id (repository_id, scope_type, next_id) values (?, ?, ?)";
    private static final LockOptions LOCK_OPTIONS = new LockOptions(LockMode.PESSIMISTIC_WRITE).setAliasSpecificLockMode("rsi", LockMode.PESSIMISTIC_WRITE);
    private static final String SELECT_SQL = "select " + StringHelper.qualify((String)"rsi", (String)"next_id") + " from " + "sta_repository_scoped_id" + " " + "rsi" + " where " + StringHelper.qualify((String)"rsi", (String)"repository_id") + " = ?" + " and " + StringHelper.qualify((String)"rsi", (String)"scope_type") + " = ?";
    private static final Map<String, String[]> UPDATED_COLUMNS = ImmutableMap.builder().put((Object)"rsi", (Object)new String[]{"next_id"}).build();
    private static final String UPDATE_SQL = "update sta_repository_scoped_id set next_id = ? where repository_id = ? and scope_type = ? and next_id = ?";
    private final SessionFactoryImplementor sessionFactory;
    private final SqlStatementLogger statementLogger;

    @Autowired
    public HibernateRepositoryScopedIdGenerator(SessionFactoryImplementor sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.statementLogger = ((JdbcServices)sessionFactory.getServiceRegistry().getService(JdbcServices.class)).getSqlStatementLogger();
    }

    public long nextId(int repositoryId, String scopeType) {
        Generator generator = new Generator(repositoryId, scopeType);
        SessionImplementor session = (SessionImplementor)this.sessionFactory.getCurrentSession();
        session.getTransactionCoordinator().getTransaction().createIsolationDelegate().delegateWork((WorkExecutorVisitable)generator, true);
        return generator.getId();
    }

    private class Generator
    extends AbstractWork {
        private final IntegralDataTypeHolder id;
        private final int repositoryId;
        private final String scopeType;

        private Generator(int repositoryId, String scopeType) {
            this.repositoryId = repositoryId;
            this.scopeType = scopeType;
            this.id = IdentifierGeneratorHelper.getIntegralDataTypeHolder(Long.class);
        }

        public void execute(Connection connection) throws HibernateException {
            int rows;
            do {
                try {
                    this.selectNextId(connection);
                    rows = this.updateNextId(connection);
                }
                catch (SQLException e) {
                    throw new HibernateException("The next ID for the [" + this.scopeType + "] scope in repository [" + this.repositoryId + "] could not be generated", (Throwable)e);
                }
            } while (rows == 0);
        }

        public long getId() {
            return (Long)this.id.makeValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void insertFirstId(Connection connection) throws SQLException {
            this.id.initialize(1L);
            PreparedStatement insert = null;
            try {
                HibernateRepositoryScopedIdGenerator.this.statementLogger.logStatement(HibernateRepositoryScopedIdGenerator.INSERT_SQL, FormatStyle.BASIC.getFormatter());
                insert = connection.prepareStatement(HibernateRepositoryScopedIdGenerator.INSERT_SQL);
                insert.setInt(1, this.repositoryId);
                insert.setString(2, this.scopeType);
                this.id.bind(insert, 3);
                insert.execute();
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(insert);
                throw throwable;
            }
            JdbcUtils.closeStatement((Statement)insert);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void selectNextId(Connection connection) throws SQLException {
            Dialect dialect = HibernateRepositoryScopedIdGenerator.this.sessionFactory.getDialect();
            String selectSql = dialect.applyLocksToSql(SELECT_SQL, LOCK_OPTIONS, UPDATED_COLUMNS);
            PreparedStatement select = null;
            try {
                HibernateRepositoryScopedIdGenerator.this.statementLogger.logStatement(selectSql, FormatStyle.BASIC.getFormatter());
                select = connection.prepareStatement(selectSql);
                select.setInt(1, this.repositoryId);
                select.setString(2, this.scopeType);
                ResultSet results = select.executeQuery();
                try {
                    if (results.next()) {
                        this.id.initialize(results, 1L);
                    } else {
                        this.insertFirstId(connection);
                    }
                }
                finally {
                    JdbcUtils.closeResultSet((ResultSet)results);
                }
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(select);
                throw throwable;
            }
            JdbcUtils.closeStatement((Statement)select);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int updateNextId(Connection connection) throws SQLException {
            int n;
            IntegralDataTypeHolder nextId = this.id.copy().increment();
            PreparedStatement update = null;
            try {
                HibernateRepositoryScopedIdGenerator.this.statementLogger.logStatement(HibernateRepositoryScopedIdGenerator.UPDATE_SQL, FormatStyle.BASIC.getFormatter());
                update = connection.prepareStatement(HibernateRepositoryScopedIdGenerator.UPDATE_SQL);
                nextId.bind(update, 1);
                update.setInt(2, this.repositoryId);
                update.setString(3, this.scopeType);
                this.id.bind(update, 4);
                n = update.executeUpdate();
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(update);
                throw throwable;
            }
            JdbcUtils.closeStatement((Statement)update);
            return n;
        }
    }
}

