/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.crowd;

import com.atlassian.crowd.dao.CriteriaFactory;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.util.persistence.hibernate.batch.AbstractBatchFinder;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Collection;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class TransactionManagerBatchFinder
extends AbstractBatchFinder {
    private final SessionFactory sessionFactory;

    public TransactionManagerBatchFinder(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Transactional(readOnly=true, propagation=Propagation.REQUIRES_NEW)
    protected <E> Collection<E> processBatchFind(long directoryID, Collection<String> names, Class<E> persistentClass) {
        Collection lowercaseNames = Collections2.transform(names, (Function)new Function<String, String>(){

            public String apply(String from) {
                return IdentifierUtils.toLowerCase((String)from);
            }
        });
        return CriteriaFactory.createCriteria((Session)this.sessionFactory.getCurrentSession(), persistentClass).add((Criterion)Restrictions.eq((String)"directory.id", (Object)directoryID)).add(Restrictions.in((String)"lowerName", (Collection)lowercaseNames)).list();
    }
}

