/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.crowd;

import com.atlassian.crowd.dao.group.GroupDAOHibernate;
import com.atlassian.crowd.dao.group.InternalGroupDao;
import com.atlassian.crowd.embedded.spi.GroupDao;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.model.group.InternalGroup;
import com.atlassian.crowd.model.group.InternalGroupAttribute;
import com.atlassian.crowd.model.group.InternalGroupWithAttributes;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.stash.internal.crowd.HibernateDirectoryDao;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class HibernateGroupDao
extends GroupDAOHibernate
implements GroupDao,
InternalGroupDao {
    public InternalGroup findByName(long directoryId, String groupName) throws GroupNotFoundException {
        return HibernateGroupDao.initialize(super.findByName(directoryId, groupName));
    }

    public Collection<InternalGroup> findByNames(long directoryID, Collection<String> groupnames) {
        return HibernateGroupDao.initialize(super.findByNames(directoryID, groupnames));
    }

    public InternalGroupWithAttributes findByNameWithAttributes(long directoryId, String groupName) throws GroupNotFoundException {
        InternalGroupWithAttributes result = super.findByNameWithAttributes(directoryId, groupName);
        HibernateGroupDao.initialize(result.getInternalGroup());
        return result;
    }

    public Set<InternalGroupAttribute> findGroupAttributes(long groupId) {
        Set result = super.findGroupAttributes(groupId);
        for (InternalGroupAttribute attribute : result) {
            HibernateDirectoryDao.initialize((DirectoryImpl)DirectoryImpl.class.cast(attribute.getDirectory()));
            HibernateGroupDao.initialize(attribute.getGroup());
        }
        return result;
    }

    public <T> List<T> search(long directoryId, EntityQuery<T> query) {
        List result = super.search(directoryId, query);
        for (Object item : result) {
            if (item instanceof InternalGroup) {
                HibernateGroupDao.initialize((InternalGroup)InternalGroup.class.cast(item));
                continue;
            }
            if (!(item instanceof InternalGroupWithAttributes)) continue;
            HibernateGroupDao.initialize(((InternalGroupWithAttributes)InternalGroupWithAttributes.class.cast(item)).getInternalGroup());
        }
        return result;
    }

    public Object load(long ID) throws ObjectNotFoundException {
        return HibernateGroupDao.initialize((InternalGroup)InternalGroup.class.cast(super.load(ID)));
    }

    public Object loadReference(long id) {
        return HibernateGroupDao.initialize((InternalGroup)InternalGroup.class.cast(super.loadReference(id)));
    }

    static InternalGroup initialize(InternalGroup group) {
        if (group != null) {
            HibernateDirectoryDao.initialize((DirectoryImpl)group.getDirectory());
        }
        return group;
    }

    static Collection<InternalGroup> initialize(Collection<InternalGroup> groups) {
        if (groups != null) {
            for (InternalGroup group : groups) {
                HibernateGroupDao.initialize(group);
            }
        }
        return groups;
    }
}

