/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth.trusted;

import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.auth.trusted.InternalTrustedApplication;
import com.atlassian.stash.internal.auth.trusted.TrustedApplicationDao;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Order;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="trustedApplicationDao")
public class HibernateTrustedApplicationDao
extends AbstractHibernateDao<Integer, InternalTrustedApplication>
implements TrustedApplicationDao {
    @Autowired
    public HibernateTrustedApplicationDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public void deleteAll() {
        this.session().createQuery("delete from InternalTrustedApplication").executeUpdate();
    }

    public Iterable<InternalTrustedApplication> findAll() {
        List apps = this.session().createQuery("FROM InternalTrustedApplication").list();
        for (InternalTrustedApplication application : apps) {
            InternalTrustedApplication.initialize((InternalTrustedApplication)application);
        }
        return apps;
    }

    public InternalTrustedApplication getByApplicationId(String applicationId) {
        Query query = this.session().createQuery("FROM InternalTrustedApplication WHERE applicationId = :applicationId").setParameter("applicationId", (Object)applicationId);
        return InternalTrustedApplication.initialize((InternalTrustedApplication)((InternalTrustedApplication)query.uniqueResult()));
    }

    @Override
    protected Order getImplicitOrder() {
        return Order.asc((String)"id");
    }

    @Override
    public InternalTrustedApplication update(InternalTrustedApplication entity) {
        InternalTrustedApplication current = this.getByApplicationId(entity.getApplicationId());
        if (current != null) {
            entity = current.copy().id(entity.getId()).certificateTimeout(entity.getCertificateTimeout()).ipPatterns(entity.getIPPatterns()).publicKey(entity.getPublicKey()).urlPatterns(entity.getUrlPatterns()).build();
        }
        return super.update(entity);
    }
}

