/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.watcher;

import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.watcher.InternalWatcher;
import com.atlassian.stash.internal.watcher.WatcherDao;
import com.atlassian.stash.pull.PullRequest;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.watcher.Watchable;
import com.atlassian.stash.watcher.WatchableVisitor;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="watcherDao")
public class HibernateWatcherDao
extends AbstractHibernateDao<Long, InternalWatcher>
implements WatcherDao {
    @Autowired
    public HibernateWatcherDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public long countWatchers(@Nonnull Watchable watchable) {
        return HibernateUtils.count((Criteria)this.particularWatchable(watchable).getExecutableCriteria(this.session()));
    }

    @Override
    public InternalWatcher create(InternalWatcher entity) {
        final InternalWatcher watcher = super.create(entity);
        watcher.getWatchable().accept(new WatchableVisitor(){

            public void visit(@Nonnull PullRequest pullRequest) {
                InternalConverter.convertToInternalPullRequest((PullRequest)pullRequest).addWatcher(watcher);
                HibernateWatcherDao.this.session().update((Object)pullRequest);
            }
        });
        return watcher;
    }

    @Override
    public void delete(final InternalWatcher entity) {
        entity.getWatchable().accept(new WatchableVisitor(){

            public void visit(@Nonnull PullRequest pullRequest) {
                InternalConverter.convertToInternalPullRequest((PullRequest)pullRequest).removeWatcher(entity);
                HibernateWatcherDao.this.session().update((Object)pullRequest);
            }
        });
        super.delete(entity);
    }

    @Nonnull
    public Set<InternalWatcher> findByWatchable(@Nonnull Watchable watchable) {
        Criteria criteria = this.particularWatchable(watchable).getExecutableCriteria(this.session());
        return ImmutableSet.copyOf((Collection)HibernateUtils.initializeList((List)criteria.list()));
    }

    @Nullable
    public InternalWatcher findByWatchableAndUser(@Nonnull Watchable watchable, @Nonnull StashUser user) {
        return (InternalWatcher)HibernateUtils.initialize((Object)((InternalWatcher)this.particularWatchableAndUser(watchable, user).getExecutableCriteria(this.session()).uniqueResult()));
    }

    @Override
    public InternalWatcher getById(Long id) {
        return (InternalWatcher)HibernateUtils.initialize(super.getById(id));
    }

    @Override
    public InternalWatcher update(InternalWatcher entity) {
        return (InternalWatcher)HibernateUtils.initialize((Object)super.update(entity));
    }

    @Override
    protected Order getImplicitOrder() {
        return Order.desc((String)"id");
    }

    private DetachedCriteria particularWatchable(Watchable watchable) {
        return DetachedCriteria.forClass(InternalWatcher.class).add((Criterion)Restrictions.eq((String)"watchable", (Object)watchable));
    }

    private DetachedCriteria particularWatchableAndUser(Watchable watchable, StashUser user) {
        return this.particularWatchable(watchable).add((Criterion)Restrictions.eq((String)"user", (Object)InternalConverter.convertToInternalUser((StashUser)user)));
    }
}

