/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.security.random.SecureTokenGenerator;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.internal.user.StashUserDao;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.UserUtils;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Order;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="stashUserDao")
public class HibernateStashUserDao
extends AbstractHibernateDao<Integer, InternalStashUser>
implements StashUserDao {
    private static final Logger log = LoggerFactory.getLogger(HibernateStashUserDao.class);
    private static final String FIELD_USERNAME = "username";
    private static final String FIELD_SLUG = "slug";
    private static final int MAX_USERNAME_LENGTH = 255;
    private static final Function<String, String> FORMAT_USERNAME = new Function<String, String>(){

        public String apply(String username) {
            return IdentifierUtils.toLowerCase((String)username);
        }
    };
    private static final Function<Principal, String> TO_FORMATTED_USERNAME = Functions.compose(FORMAT_USERNAME, (Function)UserUtils.TO_USERNAME);
    private final SecureTokenGenerator tokenGenerator;

    @Autowired
    public HibernateStashUserDao(SessionFactory sessionFactory, SecureTokenGenerator tokenGenerator) {
        super(sessionFactory);
        this.tokenGenerator = tokenGenerator;
    }

    @Nonnull
    public InternalStashUser archive(@Nonnull InternalStashUser user) {
        String archivedSlug;
        Preconditions.checkArgument((!((InternalStashUser)Preconditions.checkNotNull((Object)user, (Object)"user")).isCrowdBacked() ? 1 : 0) != 0, (Object)"Only deleted users can be archived");
        int counter = 0;
        String suffix = "_ar";
        String archivedName = this.safeAppendSuffix(user.getName(), 255, suffix);
        while (this.findByName(archivedName) != null && ++counter < 100) {
            suffix = "_ar" + counter;
            archivedName = this.safeAppendSuffix(user.getName(), 255, suffix);
        }
        if (counter == 100) {
            archivedName = this.tokenGenerator.generateToken();
            while (this.findByName(archivedName) != null) {
                archivedName = this.tokenGenerator.generateToken();
            }
            archivedSlug = this.generateUniqueSlugForUser(archivedName, user);
        } else {
            archivedSlug = this.generateUniqueSlugForUser(this.safeAppendSuffix(user.getName(), 126, suffix), user);
        }
        log.info("Archiving user {} with slug {} to {}/{}", new Object[]{user.getName(), user.getSlug(), archivedName, archivedSlug});
        return this.update(user.copy().name(archivedName).slug(archivedSlug).build());
    }

    @Nonnull
    public Page<InternalStashUser> findAllByContainedText(String containedText, @Nonnull PageRequest pageRequest) {
        return this.findAllByContainedText(containedText, pageRequest, (Predicate<? super InternalStashUser>)Predicates.alwaysTrue());
    }

    @Override
    public InternalStashUser create(InternalStashUser user) {
        String slug = this.generateUniqueSlug(user.getName());
        return super.create(user.copy().slug(slug).build());
    }

    @Nonnull
    public Page<InternalStashUser> findAllByContainedText(String containedText, @Nonnull PageRequest pageRequest, @Nonnull Predicate<? super InternalStashUser> predicate) {
        if (StringUtils.isEmpty((String)containedText)) {
            return this.findAll(pageRequest, predicate);
        }
        Query query = this.session().createQuery("from InternalStashUser where username like :username order by username").setParameter(FIELD_USERNAME, (Object)("%" + (String)FORMAT_USERNAME.apply((Object)containedText) + "%"));
        return this.pageQuery(query, pageRequest, predicate);
    }

    public InternalStashUser findByName(@Nonnull String username) {
        return (InternalStashUser)this.session().createQuery("from InternalStashUser where username = :username").setParameter(FIELD_USERNAME, FORMAT_USERNAME.apply((Object)username)).uniqueResult();
    }

    public InternalStashUser findBySlug(@Nonnull String slug) {
        return (InternalStashUser)this.session().createQuery("from InternalStashUser where slug = :slug").setParameter(FIELD_SLUG, (Object)slug).uniqueResult();
    }

    @Nonnull
    public Set<InternalStashUser> findByNames(@Nonnull Set<String> usernames) {
        if (usernames.isEmpty()) {
            return Collections.emptySet();
        }
        Query query = this.session().createQuery("from InternalStashUser where username in (:usernames) order by username").setParameterList("usernames", Collections2.transform(usernames, FORMAT_USERNAME));
        return ImmutableSet.copyOf((Collection)query.list());
    }

    public InternalStashUser loadUser(@Nonnull User user) {
        Object[] result = (Object[])this.session().createQuery("select id, slug from InternalStashUser where username = :username").setParameter(FIELD_USERNAME, FORMAT_USERNAME.apply((Object)user.getName())).uniqueResult();
        if (result == null) {
            return null;
        }
        int id = ((Number)result[0]).intValue();
        String slug = (String)result[1];
        return new InternalStashUser.Builder().crowdUser(user).id(Integer.valueOf(id)).name(user.getName()).slug(slug).build();
    }

    @Nonnull
    public Set<InternalStashUser> loadUsers(@Nonnull Iterable<User> users) {
        ImmutableMap usersByName = Maps.uniqueIndex(users, TO_FORMATTED_USERNAME);
        if (usersByName.isEmpty()) {
            return Collections.emptySet();
        }
        List results = this.session().createQuery("select username, id, slug from InternalStashUser where username in :usernames").setParameterList("usernames", usersByName.keySet()).list();
        HashSet<InternalStashUser> stashUsers = new HashSet<InternalStashUser>(usersByName.size(), 1.0f);
        for (Object result : results) {
            Object[] columns = (Object[])result;
            stashUsers.add(new InternalStashUser.Builder().crowdUser((User)usersByName.get(columns[0])).id(Integer.valueOf(((Number)columns[1]).intValue())).slug((String)columns[2]).name((String)columns[0]).build());
        }
        return stashUsers;
    }

    public InternalStashUser rename(@Nonnull String oldUsername, @Nonnull String newUsername) {
        InternalStashUser user = this.findByName(oldUsername);
        if (user == null) {
            return null;
        }
        InternalStashUser updated = this.update(user.copy().name(newUsername).slug(this.generateUniqueSlugForUser(newUsername, user)).build());
        return updated;
    }

    @Override
    protected Order getImplicitOrder() {
        return Order.asc((String)FIELD_USERNAME);
    }

    private String generateUniqueSlug(String username) {
        return this.generateUniqueSlugForUser(username, null);
    }

    private String generateUniqueSlugForUser(String username, InternalStashUser user) {
        String initialSlug;
        String slug = initialSlug = InternalStashUser.slugify((String)username);
        boolean slugFound = false;
        for (int tries = 0; tries <= 10; ++tries) {
            if (this.isSlugFree(slug, user)) {
                log.debug("{}: Using slug \"{}\"", (Object)username, (Object)slug);
                slugFound = true;
                break;
            }
            log.debug("{}: Collision detected for slug \"{}\"", (Object)username, (Object)slug);
            slug = initialSlug + tries;
        }
        if (!slugFound) {
            slug = InternalStashUser.generateSlug((SecureTokenGenerator)this.tokenGenerator);
            log.debug("{}: Using random token \"{}\" as slug", (Object)username, (Object)slug);
        }
        return slug;
    }

    private boolean isSlugFree(String slug, InternalStashUser user) {
        InternalStashUser slugUser = this.findBySlug(slug);
        return slugUser == null || user != null && slugUser.getId().equals(user.getId());
    }

    private String safeAppendSuffix(String username, int maxResultLength, String suffix) {
        return username.substring(0, Math.min(maxResultLength - suffix.length(), username.length())) + suffix;
    }
}

