/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.stash.internal.hibernate.HibernatePageUtils;
import com.atlassian.stash.internal.user.AbstractHibernateGrantedPermissionDao;
import com.atlassian.stash.internal.user.InternalGrantedPermission;
import com.atlassian.stash.internal.user.InternalProjectPermission;
import com.atlassian.stash.internal.user.ProjectPermissionDao;
import com.atlassian.stash.user.PermittedGroup;
import com.atlassian.stash.user.PermittedUser;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="grantedProjectPermissionDao")
public class HibernateProjectPermissionDao
extends AbstractHibernateGrantedPermissionDao<InternalProjectPermission>
implements ProjectPermissionDao {
    @Autowired
    public HibernateProjectPermissionDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public Page<InternalProjectPermission> findDefaultPermissions(@Nonnull PageRequest pageRequest) {
        Query query = this.session().createQuery("from InternalProjectPermission where group is null and user is null");
        return HibernatePageUtils.pageQuery(query, pageRequest);
    }

    @Nonnull
    public Page<PermittedUser> findHighestPermissionPerUser(int projectId, @Nullable String filter, @Nonnull PageRequest pageRequest) {
        Page<StashUser> page = this.findUsersWithPermission(filter, pageRequest, this.projectIdEq(projectId));
        if (page.getIsLastPage() && page.getSize() == 0) {
            return HibernatePageUtils.createEmptyPage((PageRequest)pageRequest);
        }
        Query query = this.createFindHighestPermissionPerUserQuery(page, "project.id = :projectId").setInteger("projectId", projectId);
        return this.pairUsersWithPermissions(page, query);
    }

    @Nonnull
    public Page<StashUser> findUsersWithPermission(int projectId, @Nonnull PageRequest pageRequest) {
        return this.findUsersWithPermission(null, pageRequest, this.projectIdEq(projectId));
    }

    @Nonnull
    public Page<PermittedGroup> findHighestPermissionPerGroup(int projectId, @Nullable String filter, @Nonnull PageRequest pageRequest) {
        Query query = this.createFindHighestPermissionPerGroupQuery(filter, "project.id = :projectId").setInteger("projectId", projectId);
        return HibernatePageUtils.pageQuery(query, pageRequest);
    }

    @Nonnull
    public Page<String> findGroupsWithPermission(int projectId, @Nonnull PageRequest pageRequest) {
        return this.findGroupsWithPermission(pageRequest, this.projectIdEq(projectId));
    }

    public int revoke(@Nonnull InternalProjectPermission grantedPermission) {
        return this.createRevokeQuery((InternalGrantedPermission)grantedPermission, "project.id = :projectId").setInteger("projectId", grantedPermission.getProject().getId().intValue()).executeUpdate();
    }

    public int revokeAllForProject(int projectId) {
        return this.session().createQuery("delete InternalProjectPermission p where p.project.id = :projectId").setParameter("projectId", (Object)projectId).executeUpdate();
    }

    @Override
    protected Criteria createHasPermissionEntryCriteria(InternalProjectPermission grantedPermission) {
        return super.createHasPermissionEntryCriteria(grantedPermission).add((Criterion)Restrictions.eq((String)"project", (Object)grantedPermission.getProject()));
    }

    @Override
    protected Order getImplicitOrder() {
        return Order.asc((String)"id");
    }

    private Criterion projectIdEq(int projectId) {
        return Restrictions.eq((String)"project.id", (Object)projectId);
    }
}

