/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.RepositoryDao;
import com.atlassian.stash.internal.repository.RepositoryOrder;
import com.atlassian.stash.internal.repository.RepositorySearchCriteria;
import com.atlassian.stash.project.ProjectType;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.google.common.base.Predicate;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Repository;

@Repository(value="repositoryDao")
public class HibernateRepositoryDao
extends AbstractHibernateDao<Integer, InternalRepository>
implements RepositoryDao {
    @Autowired
    public HibernateRepositoryDao(SessionFactory sessionFactory, CacheManager cacheManager) {
        super(sessionFactory);
    }

    public long countByHierarchy(String hierarchyId) {
        return HibernateUtils.count((Criteria)this.session().createCriteria(InternalRepository.class).add((Criterion)Restrictions.eq((String)"hierarchyId", (Object)hierarchyId)));
    }

    public long countByProject(int projectId) {
        return HibernateUtils.count((Criteria)this.session().createCriteria(InternalRepository.class).add((Criterion)Restrictions.eq((String)"project.id", (Object)projectId)));
    }

    public long countPublicByProject(int projectId) {
        return HibernateUtils.count((Criteria)this.session().createCriteria(InternalRepository.class).add((Criterion)Restrictions.eq((String)"project.id", (Object)projectId)).add((Criterion)Restrictions.eq((String)"publiclyAccessible", (Object)true)).setCacheable(true).setCacheRegion("query.publicRepositoryCountByProject"));
    }

    @Override
    @Nonnull
    public Page<InternalRepository> findAll(PageRequest pageRequest) {
        return HibernateUtils.initializePage(super.findAll(pageRequest));
    }

    @Override
    @Nonnull
    public Page<InternalRepository> findAll(PageRequest pageRequest, Predicate<? super InternalRepository> predicate) {
        return HibernateUtils.initializePage(super.findAll(pageRequest, predicate));
    }

    @Nonnull
    public Page<InternalRepository> findByHierarchy(@Nonnull InternalRepository repository, @Nonnull PageRequest pageRequest, @Nonnull Predicate<? super InternalRepository> predicate) {
        String hql = "from InternalRepository where id != :repositoryId and hierarchyId = :hierarchyId order by project.key, name";
        Query query = this.session().createQuery(hql).setInteger("repositoryId", repository.getId().intValue()).setString("hierarchyId", repository.getHierarchyId()).setCacheable(true).setCacheRegion("query.repositoriesByHierarchy");
        return HibernateUtils.initializePage(this.pageQuery(query, pageRequest, predicate));
    }

    @Nonnull
    public Page<InternalRepository> findByOrigin(@Nonnull InternalRepository origin, @Nonnull PageRequest pageRequest, @Nonnull Predicate<? super InternalRepository> predicate) {
        Criteria criteria = this.session().createCriteria(InternalRepository.class).add((Criterion)Restrictions.eq((String)"origin", (Object)origin));
        return HibernateUtils.initializePage(this.pageCriteria(criteria, pageRequest, predicate));
    }

    public InternalRepository findByOriginInProject(@Nonnull InternalRepository origin, int projectId) {
        return (InternalRepository)HibernateUtils.initialize((Object)((InternalRepository)this.session().createCriteria(InternalRepository.class).add((Criterion)Restrictions.eq((String)"origin", (Object)origin)).add((Criterion)Restrictions.eq((String)"project.id", (Object)projectId)).add((Criterion)Restrictions.eq((String)"slug", (Object)origin.getSlug())).uniqueResult()));
    }

    @Nonnull
    public Page<InternalRepository> findByProjectKey(@Nonnull String projectKey, @Nonnull PageRequest pageRequest, @Nonnull Predicate<? super InternalRepository> predicate) {
        String hql = "from InternalRepository where upper(project.key) = upper(:projectKey) order by upper(name)";
        Query query = this.session().createQuery(hql).setParameter("projectKey", (Object)projectKey);
        return HibernateUtils.initializePage(this.pageQuery(query, pageRequest, predicate));
    }

    @Override
    public InternalRepository getById(Integer id) {
        return (InternalRepository)HibernateUtils.initialize(super.getById(id));
    }

    @Override
    @Nonnull
    public List<InternalRepository> getByIds(@Nonnull Collection<Integer> ids) {
        return HibernateUtils.initializeList(super.getByIds(ids));
    }

    public InternalRepository getBySlug(@Nonnull String projectKey, @Nonnull String slug) {
        String hql = "from InternalRepository where upper(project.key) = upper(:projectKey) and slug = :slug";
        return (InternalRepository)HibernateUtils.initialize((Object)((InternalRepository)this.session().createQuery(hql).setString("slug", slug.toLowerCase(Locale.US)).setString("projectKey", projectKey).setCacheable(true).setCacheRegion("query.repositoryBySlug").uniqueResult()));
    }

    @Nonnull
    public List<Integer> getForkIds(@Nonnull InternalRepository repository) {
        return this.session().createCriteria(InternalRepository.class).add((Criterion)Restrictions.eq((String)"origin", (Object)repository)).setProjection((Projection)Projections.id()).list();
    }

    @Nonnull
    public Page<InternalRepository> search(@Nonnull RepositorySearchCriteria searchCriteria, @Nonnull PageRequest pageRequest, @Nonnull Predicate<? super InternalRepository> predicate) {
        Criteria criteria = this.createCriteria();
        if (this.requiresProjectJoin(searchCriteria)) {
            criteria.createAlias("project", "p");
        }
        this.maybeRestrictRepositoryName(searchCriteria, criteria);
        this.maybeRestrictProjectName(searchCriteria, criteria);
        this.maybeRestrictVisibility(searchCriteria, criteria);
        this.addOrder(searchCriteria, criteria);
        return HibernateUtils.initializePage(this.pageCriteria(criteria, pageRequest, predicate));
    }

    @Override
    public InternalRepository update(InternalRepository entity) {
        return (InternalRepository)HibernateUtils.initialize((Object)super.update(entity));
    }

    public int updateOrigin(@Nonnull InternalRepository oldOrigin, InternalRepository newOrigin) {
        Query query = newOrigin == null ? this.session().createQuery("update InternalRepository set origin = null where origin = :oldOrigin") : this.session().createQuery("update InternalRepository set origin = :newOrigin where origin = :oldOrigin").setParameter("newOrigin", (Object)newOrigin);
        return query.setParameter("oldOrigin", (Object)oldOrigin).executeUpdate();
    }

    @Override
    protected Order getImplicitOrder() {
        return Order.asc((String)"name").ignoreCase();
    }

    private void addOrder(RepositorySearchCriteria searchCriteria, Criteria criteria) {
        searchCriteria.getOrder().apply(criteria);
    }

    private void maybeRestrictProjectName(RepositorySearchCriteria searchCriteria, Criteria criteria) {
        if (searchCriteria.hasProjectName()) {
            criteria.add(Restrictions.ilike((String)"p.name", (String)searchCriteria.getProjectName(), (MatchMode)MatchMode.START));
            criteria.add((Criterion)Restrictions.eq((String)"p.type", (Object)ProjectType.NORMAL));
        }
    }

    private void maybeRestrictRepositoryName(RepositorySearchCriteria searchCriteria, Criteria criteria) {
        if (searchCriteria.hasName()) {
            criteria.add(Restrictions.ilike((String)"name", (String)searchCriteria.getName(), (MatchMode)MatchMode.START));
        }
    }

    private void maybeRestrictVisibility(RepositorySearchCriteria searchCriteria, Criteria criteria) {
        if (searchCriteria.hasVisibility()) {
            switch (searchCriteria.getVisibility()) {
                case PUBLIC: {
                    criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"publiclyAccessible", (Object)true), (Criterion)Restrictions.eq((String)"p.publiclyAccessible", (Object)true)));
                    break;
                }
                case PRIVATE: {
                    criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.ne((String)"publiclyAccessible", (Object)true), (Criterion)Restrictions.ne((String)"p.publiclyAccessible", (Object)true)));
                }
            }
        }
    }

    private boolean requiresProjectJoin(RepositorySearchCriteria searchCriteria) {
        return searchCriteria.getOrder() == RepositoryOrder.PROJECT_NAME || searchCriteria.hasVisibility() || searchCriteria.hasProjectName();
    }
}

