/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestParticipant;
import com.atlassian.stash.internal.pull.PullRequestParticipantDao;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="pullRequestParticipantDao")
public class HibernatePullRequestParticipantDao
extends AbstractHibernateDao<Long, InternalPullRequestParticipant>
implements PullRequestParticipantDao {
    @Autowired
    public HibernatePullRequestParticipantDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Override
    @Nonnull
    public InternalPullRequestParticipant create(@Nonnull InternalPullRequestParticipant participant) {
        this.session().save((Object)participant);
        InternalPullRequest pullRequest = participant.getPullRequest();
        pullRequest.addParticipant(participant);
        this.session().update((Object)pullRequest);
        return participant;
    }

    @Override
    public void delete(@Nonnull InternalPullRequestParticipant participant) {
        InternalPullRequest pullRequest = participant.getPullRequest();
        pullRequest.removeParticipant(participant);
        this.session().update((Object)pullRequest);
        this.session().delete((Object)participant);
    }

    @Override
    @Nonnull
    public InternalPullRequestParticipant update(@Nonnull InternalPullRequestParticipant participant) {
        return InternalPullRequestParticipant.initialize((InternalPullRequestParticipant)super.update(participant));
    }

    @Nonnull
    public Page<InternalPullRequestParticipant> findByPullRequest(long pullRequestId, @Nonnull PageRequest pageRequest) {
        Criteria criteria = this.session().createCriteria(InternalPullRequestParticipant.class).add((Criterion)Restrictions.eq((String)"pullRequest.id", (Object)pullRequestId)).addOrder(this.getImplicitOrder());
        Page page = this.pageCriteria(criteria, pageRequest);
        for (InternalPullRequestParticipant participant : page.getValues()) {
            InternalPullRequestParticipant.initialize((InternalPullRequestParticipant)participant);
        }
        return page;
    }

    @Nullable
    public InternalPullRequestParticipant getByPullRequestAndUser(long pullRequestId, int userId) {
        Criteria criteria = this.session().createCriteria(InternalPullRequestParticipant.class).add((Criterion)Restrictions.eq((String)"pullRequest.id", (Object)pullRequestId)).add((Criterion)Restrictions.eq((String)"user.id", (Object)userId)).addOrder(this.getImplicitOrder());
        return InternalPullRequestParticipant.initialize((InternalPullRequestParticipant)((InternalPullRequestParticipant)criteria.uniqueResult()));
    }

    @Override
    protected Order getImplicitOrder() {
        return Order.asc((String)"role");
    }
}

