/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.content.InternalChangeLocation;
import com.atlassian.stash.internal.pull.InternalPullRequestDiffCommentAnchor;
import com.atlassian.stash.internal.pull.PullRequestCommentAnchorDao;
import com.atlassian.stash.internal.pull.PullRequestCommentAnchorSearchCriteria;
import com.atlassian.stash.internal.pull.PullRequestCommentCounts;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

@Repository(value="pullRequestCommentAnchorDao")
public class HibernatePullRequestCommentAnchorDao
extends AbstractHibernateDao<Long, InternalPullRequestDiffCommentAnchor>
implements PullRequestCommentAnchorDao {
    @Autowired
    public HibernatePullRequestCommentAnchorDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public PullRequestCommentCounts getCounts(long pullRequestId) {
        List results = this.session().createQuery("select pca.orphaned, count(pca) from InternalPullRequestDiffCommentAnchor pca where pca.pullRequest.id = :pullRequestId group by pca.orphaned").setLong("pullRequestId", pullRequestId).list();
        TotalCountHelper helper = new TotalCountHelper();
        for (Object result : results) {
            helper.setCountFrom((Object[])result);
        }
        return helper.getCounts();
    }

    @Nonnull
    public Map<InternalChangeLocation, PullRequestCommentCounts> getCountsByLocation(long pullRequestId) {
        List results = this.session().createQuery("select pca.path, pca.srcPath, pca.orphaned, count(pca) from InternalPullRequestDiffCommentAnchor pca where pca.pullRequest.id = :pullRequestId group by pca.path, pca.srcPath, pca.orphaned order by pca.path, pca.srcPath").setLong("pullRequestId", pullRequestId).list();
        if (results.isEmpty()) {
            return Collections.emptyMap();
        }
        return HibernatePullRequestCommentAnchorDao.mapCounts(results);
    }

    @Nonnull
    public List<InternalPullRequestDiffCommentAnchor> search(@Nonnull PullRequestCommentAnchorSearchCriteria searchCriteria) {
        DetachedCriteria criteria = this.createAnchorCriteria(searchCriteria);
        if (!searchCriteria.hasPath()) {
            criteria.addOrder(Order.asc((String)"path").ignoreCase());
        }
        criteria.addOrder(Order.asc((String)"line")).addOrder(Order.asc((String)"id"));
        return criteria.getExecutableCriteria(this.session()).list();
    }

    @Override
    protected Order getImplicitOrder() {
        return Order.asc((String)"id");
    }

    private DetachedCriteria createAnchorCriteria(PullRequestCommentAnchorSearchCriteria searchCriteria) {
        DetachedCriteria criteria = DetachedCriteria.forClass(InternalPullRequestDiffCommentAnchor.class).add((Criterion)Restrictions.eq((String)"pullRequest", (Object)searchCriteria.getPullRequest()));
        if (searchCriteria.hasToHash()) {
            criteria.add((Criterion)Restrictions.eq((String)"toHash", (Object)searchCriteria.getToHash()));
            if (searchCriteria.hasFromHash()) {
                criteria.add((Criterion)Restrictions.eq((String)"fromHash", (Object)searchCriteria.getFromHash()));
            } else {
                criteria.add(Restrictions.isNull((String)"fromHash"));
            }
        } else {
            criteria.add((Criterion)Restrictions.eq((String)"orphaned", (Object)false));
        }
        if (searchCriteria.hasPath()) {
            criteria.add((Criterion)Restrictions.eq((String)"path", (Object)searchCriteria.getPath()));
        }
        return criteria;
    }

    private static Map<InternalChangeLocation, PullRequestCommentCounts> mapCounts(List<?> results) {
        HashMap counts = Maps.newHashMapWithExpectedSize((int)results.size());
        for (int i = 0; i < results.size(); ++i) {
            Object[] nextColumns;
            LocationCountHelper helper = new LocationCountHelper((Object[])results.get(i));
            int next = i + 1;
            if (next < results.size() && helper.merge(nextColumns = (Object[])results.get(next))) {
                ++i;
            }
            counts.put(helper.getLocation(), helper.getCounts());
        }
        return counts;
    }

    private static class TotalCountHelper
    extends CountHelper {
        private TotalCountHelper() {
            super(1, 0);
        }
    }

    private static class LocationCountHelper
    extends CountHelper {
        private final String path;
        private final String srcPath;

        private LocationCountHelper(Object[] columns) {
            super(3, 2);
            this.path = (String)columns[0];
            this.srcPath = (String)columns[1];
            this.setCountFrom(columns);
        }

        public InternalChangeLocation getLocation() {
            return new InternalChangeLocation.Builder().path(this.path).srcPath(this.srcPath).build();
        }

        public boolean merge(Object[] columns) {
            if (this.path.equals(columns[0]) && ObjectUtils.nullSafeEquals((Object)this.srcPath, (Object)columns[1])) {
                this.setCountFrom(columns);
                return true;
            }
            return false;
        }
    }

    private static abstract class CountHelper {
        private final int countColumn;
        private final int flagColumn;
        protected int activeCount;
        protected int orphanedCount;

        protected CountHelper(int countColumn, int flagColumn) {
            this.countColumn = countColumn;
            this.flagColumn = flagColumn;
        }

        public PullRequestCommentCounts getCounts() {
            return new PullRequestCommentCounts(this.activeCount, this.orphanedCount);
        }

        public void setCountFrom(Object[] columns) {
            boolean orphaned = (Boolean)columns[this.flagColumn];
            int count = ((Number)columns[this.countColumn]).intValue();
            if (orphaned) {
                this.orphanedCount = count;
            } else {
                this.activeCount = count;
            }
        }
    }
}

