/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.plugin.PluginState;
import com.atlassian.stash.internal.plugin.PluginStateDao;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Order;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="pluginStateDao")
public class HibernatePluginStateDao
extends AbstractHibernateDao<String, PluginState>
implements PluginStateDao {
    @Autowired
    public HibernatePluginStateDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Override
    protected Order getImplicitOrder() {
        return Order.asc((String)"name");
    }

    public PluginState findByName(String name) {
        Query query = this.session().createQuery("from PluginState where name = :name");
        query.setParameter("name", (Object)name);
        PluginState pluginState = (PluginState)query.uniqueResult();
        if (pluginState != null) {
            this.session().evict((Object)pluginState);
        }
        return pluginState;
    }

    public Iterable<PluginState> findAll() {
        List result = this.session().createQuery("FROM PluginState").list();
        for (PluginState state : result) {
            this.session().evict((Object)state);
        }
        return result;
    }

    public void clear() {
        this.session().createQuery("DELETE FROM PluginState").executeUpdate();
    }
}

