/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.idx;

import com.atlassian.stash.idx.ChangesetIndexer;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.idx.ChangesetIndexerStateDao;
import com.atlassian.stash.internal.idx.InternalChangesetIndexerState;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.repository.Repository;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Order;
import org.springframework.beans.factory.annotation.Autowired;

@org.springframework.stereotype.Repository(value="changesetIndexerStateDao")
public class HibernateChangesetIndexerStateDao
extends AbstractHibernateDao<InternalChangesetIndexerState.PK, InternalChangesetIndexerState>
implements ChangesetIndexerStateDao {
    @Override
    protected Order getImplicitOrder() {
        return Order.asc((String)"indexerId");
    }

    @Autowired
    public HibernateChangesetIndexerStateDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    private Set<String> extractIds(Iterable<ChangesetIndexer> indexers) {
        HashSet indexerIds = Sets.newHashSet();
        for (ChangesetIndexer indexer : indexers) {
            indexerIds.add(indexer.getId());
        }
        return indexerIds;
    }

    public Long getOldestLastRunTimestamp(@Nonnull Repository repository, @Nonnull Iterable<ChangesetIndexer> indexers) {
        Query query;
        Object[] result;
        Set<String> indexerIds = this.extractIds(indexers);
        if (!indexerIds.isEmpty() && (result = (Object[])(query = this.session().createQuery("select count(indexerId), min(lastRun) from InternalChangesetIndexerState WHERE indexerId in (:ids) AND repository.id = :repo_id").setParameterList("ids", indexerIds).setParameter("repo_id", (Object)repository.getId())).uniqueResult()) != null) {
            Number count = (Number)result[0];
            Long lastRun = (Long)result[1];
            if (Iterables.size(indexers) <= count.intValue()) {
                return lastRun;
            }
        }
        return null;
    }

    public Long getLastRunTimestamp(@Nonnull Repository repository, @Nonnull ChangesetIndexer indexer) {
        InternalChangesetIndexerState state = (InternalChangesetIndexerState)this.getById(new InternalChangesetIndexerState.PK(indexer.getId(), repository.getId().intValue()));
        return state == null ? null : state.getLastRun();
    }

    @Nonnull
    public Set<Long> getReferencedLastRunTimestamps(@Nonnull Repository repository) {
        Query query = this.session().createQuery("select distinct lastRun from InternalChangesetIndexerState where repository.id = :repoId").setParameter("repoId", (Object)repository.getId());
        return ImmutableSet.copyOf((Collection)query.list());
    }

    public void setLastRunTimestamp(@Nonnull Repository repository, @Nonnull ChangesetIndexer indexer, long timestamp) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        Preconditions.checkNotNull((Object)indexer, (Object)"indexer");
        Preconditions.checkNotNull((Object)indexer.getId(), (Object)"indexer.id");
        InternalChangesetIndexerState state = new InternalChangesetIndexerState(indexer.getId(), (InternalRepository)repository, Long.valueOf(timestamp));
        this.update(state);
    }

    public void setLastRunTimestamp(@Nonnull Repository repository, @Nonnull Iterable<ChangesetIndexer> indexers, long timestamp) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        Preconditions.checkNotNull(indexers, (Object)"indexers");
        for (ChangesetIndexer indexer : indexers) {
            this.setLastRunTimestamp(repository, indexer, timestamp);
        }
    }
}

