/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hibernate.dialect.resolver;

import com.atlassian.stash.internal.hibernate.dialect.CustomMySqlDialect;
import com.atlassian.stash.internal.hibernate.dialect.CustomPostgres81Dialect;
import com.atlassian.stash.internal.hibernate.dialect.CustomPostgres82Dialect;
import com.atlassian.stash.internal.hibernate.dialect.CustomSqlServer2005Dialect;
import com.atlassian.stash.internal.hibernate.dialect.CustomSqlServer2008Dialect;
import com.atlassian.stash.internal.hibernate.dialect.CustomSqlServerDialect;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.hibernate.dialect.Dialect;
import org.hibernate.service.jdbc.dialect.internal.AbstractDialectResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomDialectResolver
extends AbstractDialectResolver {
    private static final Logger log = LoggerFactory.getLogger(CustomDialectResolver.class);

    protected Dialect resolveDialectInternal(DatabaseMetaData metaData) throws SQLException {
        int databaseMajorVersion;
        String databaseName = metaData.getDatabaseProductName();
        if (databaseName.startsWith("Microsoft SQL Server")) {
            databaseMajorVersion = metaData.getDatabaseMajorVersion();
            switch (databaseMajorVersion) {
                case 8: {
                    log.debug("Returning custom SQL Server 2000 dialect for {} (Version: {})", (Object)databaseName, (Object)databaseMajorVersion);
                    return new CustomSqlServerDialect();
                }
                case 9: {
                    log.debug("Returning custom SQL Server 2005 dialect for {} (Version: {})", (Object)databaseName, (Object)databaseMajorVersion);
                    return new CustomSqlServer2005Dialect();
                }
                case 10: 
                case 11: {
                    log.debug("Returning custom SQL Server 2008 dialect for {} (Version: {})", (Object)databaseName, (Object)databaseMajorVersion);
                    return new CustomSqlServer2008Dialect();
                }
            }
        }
        if ("MySQL".equals(databaseName)) {
            log.debug("Returning custom MySQL dialect for {}", (Object)databaseName);
            return new CustomMySqlDialect();
        }
        if ("PostgreSQL".equals(databaseName)) {
            databaseMajorVersion = metaData.getDatabaseMajorVersion();
            int databaseMinorVersion = metaData.getDatabaseMinorVersion();
            if (databaseMajorVersion > 8 || databaseMajorVersion == 8 && databaseMinorVersion >= 2) {
                log.debug("Returning custom PostgreSQL 8.2 dialect for {} (Version: {}.{})", new Object[]{databaseName, databaseMajorVersion, databaseMinorVersion});
                return new CustomPostgres82Dialect();
            }
            log.debug("Returning custom PostgreSQL 8.1 dialect for {} (Version: {}.{})", new Object[]{databaseName, databaseMajorVersion, databaseMinorVersion});
            return new CustomPostgres81Dialect();
        }
        return null;
    }
}

