/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.db;

import com.atlassian.stash.Product;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.backup.MigrationTarget;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseMigrationTarget;
import com.atlassian.stash.internal.db.DatabaseSupplier;
import com.atlassian.stash.internal.db.DatabaseSupportLevel;
import com.atlassian.stash.internal.db.DatabaseValidationException;
import com.atlassian.stash.internal.db.DatabaseValidator;
import com.atlassian.stash.internal.db.DetailedDatabase;
import java.sql.Connection;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.stereotype.Component;

@Component(value="databaseValidator")
public class DefaultDatabaseValidator
implements DatabaseValidator {
    private static final Logger log = LoggerFactory.getLogger(DefaultDatabaseValidator.class);
    private final DatabaseSupplier databaseSupplier;
    private final I18nService i18nService;

    @Autowired
    public DefaultDatabaseValidator(DatabaseSupplier databaseSupplier, I18nService i18nService) {
        this.databaseSupplier = databaseSupplier;
        this.i18nService = i18nService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(@Nonnull DataSource dataSource) {
        Connection connection = null;
        try {
            connection = DataSourceUtils.getConnection((DataSource)dataSource);
            DetailedDatabase database = this.databaseSupplier.getForConnection(connection);
            if (database.getSupportLevel() == DatabaseSupportLevel.UNSUPPORTED) {
                throw new DatabaseValidationException(this.i18nService.getKeyedText("stash.db.unsupporteddatabase", "The target database is {1} {2}. This database is not supported; it has known issues when used with {0}. Please use a supported database. For more information about which databases are supported, please refer to the {0} documentation.", new Object[]{Product.NAME, database.getName(), database.getVersion()}));
            }
            MigrationTarget target = this.createMigrationTarget(connection);
            if (!target.isUtf8()) {
                log.debug("The target database is not configured for UTF-8 support");
                throw new DatabaseValidationException(this.i18nService.getKeyedText("stash.db.validation.notutf8", "The target database is not configured for UTF-8 support. For information about creating a database for use with {0}, please refer to the {0} documentation.", new Object[]{Product.NAME}));
            }
            if (!target.hasNoClashingTables()) {
                log.debug("The target database contains {} tables", (Object)Product.NAME);
                throw new DatabaseValidationException(this.i18nService.getKeyedText("stash.db.validation.notempty", "The target database contains tables whose names collide with {0}''s tables. Please migrate to a clean, empty database. For more information about creating a database for use with {0}, please refer to the {0} documentation.", new Object[]{Product.NAME}));
            }
            if (!target.hasRequiredSchemaPermissions()) {
                log.debug("The database user does not have the required schema permissions");
                throw new DatabaseValidationException(this.i18nService.getKeyedText("stash.db.validation.insufficientpermissions", "{0} does not have adequate permissions to modify the target database when connected as the specified user. Please check that the user has permission to CREATE and DROP tables and to INSERT and DELETE data. For information about creating a database for use with {0}, please refer to the {0} documentation.", new Object[]{Product.NAME}));
            }
            if (!target.hasRequiredTemporaryTablePermission()) {
                log.debug("The database user does not have the required temporary table permission");
                throw new DatabaseValidationException(this.i18nService.getKeyedText("stash.db.validation.insufficienttemporarytablepermission", "{0} does not have adequate permissions to create a temporary table in the target database when connected as the specified user. Please check that the user has permission to CREATE TEMPORARY TABLES. For information about creating a database for use with {0}, please refer to the {0} documentation.", new Object[]{Product.NAME}));
            }
            if (!target.isCaseSensitive()) {
                log.debug("The target database is not case sensitive.");
                throw new DatabaseValidationException(this.i18nService.getKeyedText("stash.db.validation.notcasesensitive", "{0} requires a case-sensitive database, but the target database is case-insensitive. For information about creating a database for use with {0}, please refer to the {0} documentation.", new Object[]{Product.NAME}));
            }
        }
        finally {
            DataSourceUtils.releaseConnection((Connection)connection, (DataSource)dataSource);
        }
    }

    protected MigrationTarget createMigrationTarget(Connection connection) {
        return new LiquibaseMigrationTarget(connection);
    }
}

