/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.crowd;

import com.atlassian.crowd.dao.user.InternalUserDao;
import com.atlassian.crowd.dao.user.UserDAOHibernate;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.spi.UserDao;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.model.user.InternalUser;
import com.atlassian.crowd.model.user.InternalUserAttribute;
import com.atlassian.crowd.model.user.InternalUserCredentialRecord;
import com.atlassian.crowd.model.user.InternalUserWithAttributes;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.util.BatchResult;
import com.atlassian.crowd.util.InternalEntityUtils;
import com.atlassian.crowd.util.persistence.hibernate.batch.HibernateOperation;
import com.atlassian.crowd.util.persistence.hibernate.batch.hibernate4.operation.RemoveUserOperation;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.event.ProjectModifiedEvent;
import com.atlassian.stash.internal.crowd.HibernateDirectoryDao;
import com.atlassian.stash.internal.project.InternalPersonalProject;
import com.atlassian.stash.internal.project.InternalProject;
import com.atlassian.stash.internal.project.ProjectDao;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.internal.user.StashUserDao;
import com.atlassian.stash.project.Project;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.hibernate.Hibernate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class HibernateUserDao
extends UserDAOHibernate
implements UserDao,
InternalUserDao {
    private final TransactionTemplate readOnlyTxTemplate;
    private final ProjectDao projectDao;
    private final StashUserDao stashUserDao;
    private final EventPublisher eventPublisher;
    private int batchSize;

    @Autowired
    public HibernateUserDao(PlatformTransactionManager transactionManager, ProjectDao projectDao, StashUserDao stashUserDao, EventPublisher eventPublisher) {
        this.projectDao = projectDao;
        this.stashUserDao = stashUserDao;
        this.eventPublisher = eventPublisher;
        this.readOnlyTxTemplate = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
        this.readOnlyTxTemplate.setReadOnly(true);
    }

    public InternalUser add(User user, PasswordCredential passwordCredential) throws UserAlreadyExistsException, IllegalArgumentException, DirectoryNotFoundException {
        this.createIfNeeded(user);
        return super.add(user, passwordCredential);
    }

    public BatchResult<User> addAll(Set<UserTemplateWithCredentialAndAttributes> userTemplateWithCredentialAndAttributes) {
        BatchResult result = super.addAll(userTemplateWithCredentialAndAttributes);
        int count = 0;
        for (User createdUser : result.getSuccessfulEntities()) {
            this.createIfNeeded(createdUser);
            if (++count < this.batchSize) continue;
            count = 0;
            this.session().flush();
            this.session().clear();
        }
        return result;
    }

    public InternalUser findByName(long directoryId, String username) throws UserNotFoundException {
        return HibernateUserDao.initialize(super.findByName(directoryId, username));
    }

    public InternalUserWithAttributes findByNameWithAttributes(long directoryId, String username) throws UserNotFoundException {
        InternalUserWithAttributes result = super.findByNameWithAttributes(directoryId, username);
        if (result != null) {
            HibernateUserDao.initialize(result.getInternalUser());
        }
        return result;
    }

    public Set<InternalUserAttribute> findUserAttributes(long userID) {
        Set result = super.findUserAttributes(userID);
        for (InternalUserAttribute attribute : result) {
            HibernateUserDao.initialize(attribute.getUser());
            HibernateDirectoryDao.initialize((DirectoryImpl)DirectoryImpl.class.cast(attribute.getDirectory()));
        }
        return result;
    }

    public Collection<InternalUser> findByNames(long directoryID, Collection<String> usernames) {
        return HibernateUserDao.initialize(super.findByNames(directoryID, usernames));
    }

    public Object load(long ID) throws ObjectNotFoundException {
        return HibernateUserDao.initialize((InternalUser)InternalUser.class.cast(super.load(ID)));
    }

    public Object loadReference(long id) {
        return HibernateUserDao.initialize((InternalUser)InternalUser.class.cast(super.loadReference(id)));
    }

    public InternalUser rename(User user, String newUsername) throws UserNotFoundException, UserAlreadyExistsException {
        InternalStashUser existingUser = this.stashUserDao.findByName(newUsername);
        if (existingUser != null) {
            if (existingUser.isCrowdBacked()) {
                throw new UserAlreadyExistsException(existingUser.getBackingCrowdUser().getDirectoryId(), existingUser.getName());
            }
            existingUser = this.stashUserDao.archive(existingUser);
            this.renamePersonalProject(existingUser);
        }
        String oldUsername = user.getName();
        InternalUser renamedUser = super.rename(user, newUsername);
        InternalStashUser renamedStashUser = this.stashUserDao.rename(oldUsername, newUsername);
        if (renamedStashUser == null) {
            this.logger.info("User {} not found during rename to {}. Creating a new user instead.", (Object)user.getName(), (Object)newUsername);
            this.createIfNeeded((User)renamedUser);
        } else {
            this.renamePersonalProject(renamedStashUser);
        }
        return renamedUser;
    }

    public BatchResult<String> removeAllUsers(final long directoryId, final Set<String> userNames) {
        Collection users = (Collection)this.readOnlyTxTemplate.execute((TransactionCallback)new TransactionCallback<Collection<InternalUser>>(){

            public Collection<InternalUser> doInTransaction(TransactionStatus status) {
                return HibernateUserDao.this.findByNames(directoryId, userNames);
            }
        });
        BatchResult batchResult = this.batchProcessor.execute((HibernateOperation)new RemoveUserOperation(), users);
        BatchResult overallResult = new BatchResult(userNames.size());
        overallResult.addFailures(Collections2.transform((Collection)batchResult.getFailedEntities(), (Function)InternalEntityUtils.GET_NAME));
        overallResult.addSuccesses(Collections2.transform((Collection)batchResult.getSuccessfulEntities(), (Function)InternalEntityUtils.GET_NAME));
        return overallResult;
    }

    public <T> List<T> search(long directoryID, EntityQuery<T> query) {
        List result = super.search(directoryID, query);
        for (Object item : result) {
            if (item instanceof InternalUser) {
                HibernateUserDao.initialize((InternalUser)InternalUser.class.cast(item));
            }
            if (!(item instanceof InternalUserCredentialRecord)) continue;
            HibernateUserDao.initialize(((InternalUserCredentialRecord)InternalUserCredentialRecord.class.cast(item)).getUser());
        }
        return result;
    }

    @Value(value="${hibernate.jdbc.batch_size}")
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @VisibleForTesting
    void createIfNeeded(User crowdUser) {
        if (this.stashUserDao.findByName(crowdUser.getName()) == null) {
            InternalStashUser stashUser = new InternalStashUser.Builder().name(crowdUser.getName()).build();
            this.stashUserDao.create((Object)stashUser);
        }
    }

    @VisibleForTesting
    void renamePersonalProject(InternalStashUser user) {
        InternalPersonalProject project = this.projectDao.getByOwner(user.getId().intValue());
        if (project != null) {
            InternalPersonalProject current = project.copy().build();
            InternalPersonalProject updated = current.copy().owner(user).build();
            if (!current.getKey().equals(updated.getKey())) {
                updated = (InternalProject)this.projectDao.update((Object)updated);
                this.eventPublisher.publish((Object)new ProjectModifiedEvent((Object)this, (Project)current, (Project)updated));
            }
        }
    }

    static InternalUser initialize(InternalUser user) {
        if (user != null) {
            HibernateDirectoryDao.initialize((DirectoryImpl)DirectoryImpl.class.cast(user.getDirectory()));
            Hibernate.initialize((Object)user.getCredentialRecords());
            for (InternalUserCredentialRecord credentialRecord : user.getCredentialRecords()) {
                Hibernate.initialize((Object)credentialRecord.getUser());
            }
        }
        return user;
    }

    static Collection<InternalUser> initialize(Collection<InternalUser> users) {
        if (users != null) {
            for (InternalUser user : users) {
                HibernateUserDao.initialize(user);
            }
        }
        return users;
    }
}

