/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.comment;

import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.comment.CommentDao;
import com.atlassian.stash.internal.comment.InternalComment;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Order;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="commentDao")
public class HibernateCommentDao
extends AbstractHibernateDao<Long, InternalComment>
implements CommentDao {
    @Autowired
    public HibernateCommentDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Override
    public InternalComment create(InternalComment entity) {
        InternalComment created = super.create(entity);
        InternalComment parent = created.getParent();
        if (parent != null) {
            parent.addComment(created);
            this.session().update((Object)parent);
        }
        return created;
    }

    @Override
    public void delete(InternalComment entity) {
        InternalComment parent = entity.getParent();
        if (parent != null) {
            parent.removeComment(entity);
            this.session().update((Object)parent);
        }
        this.session().createQuery("delete from InternalPullRequestCommentActivity where comment.id = :id").setLong("id", entity.getId().longValue()).executeUpdate();
        super.delete(entity);
    }

    @Override
    public InternalComment getById(Long id) {
        return (InternalComment)HibernateUtils.initialize(super.getById(id));
    }

    @Override
    public InternalComment update(InternalComment entity) {
        return (InternalComment)HibernateUtils.initialize((Object)super.update(entity));
    }

    @Override
    protected Order getImplicitOrder() {
        return Order.asc((String)"createdDate");
    }
}

